#include "wsint.h"
#include <glib-object.h>

enum
{
    PROP_0,
    PROP_DISPLAY,
    PROP_XID
};

G_DEFINE_TYPE (WsResource, ws_resource, G_TYPE_OBJECT);

static void
ws_resource_finalize (GObject *object)
{
    G_OBJECT_CLASS (ws_resource_parent_class)->finalize (object);
}

static void
ws_resource_set_property (GObject         *object,
			  guint            prop_id,
			  const GValue    *value,
			  GParamSpec      *pspec)
{
    WsResource *resource = WS_RESOURCE (object);
    
    switch (prop_id)
    {
    case PROP_DISPLAY:
	resource->display = g_value_get_object (value);
	break;
    case PROP_XID:
	resource->xid = g_value_get_ulong (value);
	break;
    default:
	break;
    }
}

static void
ws_resource_get_property (GObject         *object,
			  guint            prop_id,
			  GValue          *value,
			  GParamSpec      *pspec)
{
    WsResource *resource = WS_RESOURCE (object);
    
    switch (prop_id)
    {
    case PROP_DISPLAY:
	g_value_set_object (value, resource->display);
	break;
    case PROP_XID:
	g_value_set_ulong (value, resource->xid);
	break;
    default:
	break;
    }
}

static GObject *
ws_resource_constructor (GType		        type,
			 guint		        n_construct_properties,
			 GObjectConstructParam *construct_params)
{
    GObject *object;
    WsResource *resource;
    
    object = G_OBJECT_CLASS (ws_resource_parent_class)->constructor (
	type, n_construct_properties, construct_params);
    
    resource = WS_RESOURCE (object);
    
    if (resource->xid == None || resource->display == NULL)
    {
	g_error ("Display and XID must be specified when creating "
		 "a resource");
    }
    
    _ws_display_add_resource (resource->display, resource->xid, resource);
    
    return object;
}

static void
ws_resource_class_init (WsResourceClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    
    object_class->finalize = ws_resource_finalize;
    object_class->constructor = ws_resource_constructor;
    object_class->get_property = ws_resource_get_property;
    object_class->set_property = ws_resource_set_property;
    
    g_object_class_install_property (
	object_class, PROP_DISPLAY,
	g_param_spec_object ("display",
			     "Display",
			     "Display of the resource",
			     WS_TYPE_DISPLAY,
			     G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
    
    g_object_class_install_property (
	object_class, PROP_XID,
	g_param_spec_ulong ("xid",
			    "XID",
			    "XID of resource",
			    0, G_MAXLONG, None,
			    G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static void
ws_resource_init (WsResource *resource)
{
    
}
