/*
 * Copyright 2001-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.net.pop3;

import junit.framework.Test;
import junit.framework.TestSuite;

/** 
 * @author <a href="mailto:commons-dev@apache.org">[Net]</a>
 * @version $Id: AllTests.java,v 1.1 2004/09/02 15:44:26 rwinston Exp $
 *
 * The POP3* tests all presume the existence of the following parameters:
 *   mailserver: localhost (running on the default port 110)
 *   account: username=test; password=password
 *   account: username=alwaysempty; password=password.
 *   mail: At least four emails in the test account and zero emails
 *         in the alwaysempty account
 *
 * If this won't work for you, you can change these parameters in the
 * TestSetupParameters class.
 *
 * The tests were originally run on a default installation of James.
 * Your mileage may vary based on the POP3 server you run the tests against.
 * Some servers are more standards-compliant than others.
 */
public class AllTests {

	public static Test suite() {
		TestSuite suite =
			new TestSuite("Test for org.apache.commons.net.pop3");
		//$JUnit-BEGIN$
		suite.addTest(POP3ConstructorTest.suite());
		suite.addTest(POP3ClientTest.suite());
		suite.addTest(POP3ClientCommandsTest.suite());
		//$JUnit-END$
		return suite;
	}
}
