/*--------------------------------------------------------------------------+
$Id: SimulinkIdProvider.java 26277 2010-02-18 10:46:58Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.util;

import edu.tum.cs.commons.collections.IIdProvider;
import edu.tum.cs.commons.test.DeepCloneTestUtils;
import edu.tum.cs.simulink.model.SimulinkElementBase;
import edu.tum.cs.simulink.model.SimulinkLine;
import edu.tum.cs.simulink.model.SimulinkPortBase;
import edu.tum.cs.simulink.model.stateflow.IStateflowElement;
import edu.tum.cs.simulink.model.stateflow.StateflowElementBase;
import edu.tum.cs.simulink.model.stateflow.StateflowTransition;

/**
 * Id provider to be used for {@link DeepCloneTestUtils}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26277 $
 * @levd.rating GREEN Hash: F18B1CA1B02EFCE38AD48C47DA487704
 */
public class SimulinkIdProvider implements IIdProvider<String, Object> {
	/**
	 * Obtain id for element.
	 * 
	 * @throws RuntimeException
	 *             if an unknown type was encountered.
	 */
	public String obtainId(Object object) {
		if (object instanceof SimulinkElementBase) {
			return ((SimulinkElementBase) object).getName();
		}
		if (object instanceof StateflowElementBase<?>) {
			return ((IStateflowElement<?>) object).getStateflowId();
		}
		if (object instanceof SimulinkPortBase) {
			SimulinkPortBase port = (SimulinkPortBase) object;
			return port.getBlock().getId() + "-" + port.getIndex();
		}
		if (object instanceof SimulinkLine) {
			SimulinkLine line = (SimulinkLine) object;
			return obtainId(line.getSrcPort()) + "-"
					+ obtainId(line.getDstPort());
		}
		if (object instanceof StateflowTransition) {
			StateflowTransition transition = (StateflowTransition) object;

			if (transition.getSrc() == null) {
				return "null-" + obtainId(transition.getDst());
			}

			return obtainId(transition.getSrc()) + "-"
					+ obtainId(transition.getDst());
		}
		throw new RuntimeException("Unknown type " + object.getClass());
	}
}