#if   !defined(__COMMAND_HPP)
#define  __COMMAND_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ABSTRACTCOMMAND_HPP)
#include <AbstractCommand.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( Command );

   /**
   Command captures the semantics of allowing
   commands to be added as a reverse command
   type. It adds the reverse execution interface along
   with the storage for the AbstractCommand that is
   considered the reverse.
   */

   class Command : public AbstractCommand
   {

   public:

      //
      // Constructors and destructor
      //
                        /// Default Constructor

                        Command( void );

                        /// Copy constructor

                        Command( CommandCref );

                        /// Constructor with reverse command

                        Command( AbstractCommandPtr );

                        /// Virtual Destructor

      virtual           ~Command( void );      

      //
      // Operator overloads
      //

               /// Assignment operator

               CommandRef   operator=( CommandCref );

               /// Equality operator

               bool  operator==( CommandCref ) const;

      //
      // Accessors
      //

               /**
               Retrieves the reverse command
               @return AbstractCommand pointer or NULLPTR
               */

      virtual  AbstractCommandPtr   getReverseCommand( void ) const;

      //
      // Mutators
      //

               /**
               Sets the reverse command pointer to be
               used by the executeReverse call.
               @param AbstractCommand pointer to valid
               command or NULLPTR
               */

      virtual  void  setReverseCommand( AbstractCommandPtr );

               /**
               If theReverseCommand is not null, call its
               execute method.
               */

      virtual  void  executeReverse( void ) ;

   protected:

               /// The infamous reverse command

               AbstractCommandPtr   theReverseCommand;

   private:

   };
}

#endif // if !defined(__COMMAND_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/03 03:56:47 $
   $Locker:  $
*/


