/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ACCOUNTPROXY_HPP)
#include <AccountProxy.hpp>
#endif

using namespace corelinux;

//
// Default constructor
//

AccountProxy::AccountProxy( void )
   :
   AbstractBankAccount(),
   Proxy<AbstractBankAccount>()
{
   ;  // do nothing
}

//
// Initializing constructor
//

AccountProxy::AccountProxy( AbstractBankAccountPtr aSubject )
   :
   AbstractBankAccount(),
   Proxy<AbstractBankAccount>( aSubject )
{
   ;  // do nothing
}

//
// Copy constructor
//

AccountProxy::AccountProxy( AccountProxyCref aProxy )
   :
   AbstractBankAccount(),
   Proxy<AbstractBankAccount>( aProxy )
{
   ;  // do nothing
}

//
// Destructor
//

AccountProxy::~AccountProxy( void )
{
   ;  // do nothing
}
//
// Assignment operator, because the possibility that multiple
// proxies can share a single account we check if they are
// different.
//

AccountProxyRef   AccountProxy::operator=( AccountProxyCref aProxy )
{
   if( this != &aProxy )
   {
      if( theSubject != aProxy.theSubject )
      {
         theSubject = aProxy.theSubject;
      }
      else
      {
         ;  // do nothing
      }
   }
   else
   {
      ;  // do nothing
   }
   return ( *this );
}

//
// Equality overload
//

bool AccountProxy::operator==( AccountProxyCref aProxy ) const
{
   return ( this == &aProxy || theSubject == aProxy.theSubject );
}

//
// Retrieve the balance
//

AmountCref  AccountProxy::getBalance( void ) const
{
   return getSubject().getBalance();
}

//
// Withdraw funds from account
//

void  AccountProxy::withdrawFunds( Amount anAmount )
                        throw(InsufficientFundsException)
{
   ( *this )->withdrawFunds( anAmount );
}

//
// Deposit funds into the account
//

void  AccountProxy::depositFunds( Amount anAmount )
                        throw(InsufficientFundsException)
{
   ( *this )->depositFunds( anAmount );
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/02/08 13:13:17 $
   $Locker:  $
*/

