# This Makefile.PL for DateTime-Locale was generated by
# Dist::Zilla::Plugin::DROLSKY::MakeMaker 0.95
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.42.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;
check_conflicts();

use File::ShareDir::Install;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT" => "Localization support for DateTime.pm",
  "AUTHOR" => "Dave Rolsky <autarch\@urth.org>",
  "CONFIGURE_REQUIRES" => {
    "Dist::CheckConflicts" => "0.02",
    "ExtUtils::MakeMaker" => 0,
    "File::ShareDir::Install" => "0.03"
  },
  "DISTNAME" => "DateTime-Locale",
  "LICENSE" => "perl",
  "NAME" => "DateTime::Locale",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Dist::CheckConflicts" => "0.02",
    "Exporter" => 0,
    "File::ShareDir" => 0,
    "List::Util" => "1.45",
    "Params::ValidationCompiler" => "0.13",
    "Specio::Declare" => 0,
    "Specio::Library::String" => 0,
    "namespace::autoclean" => "0.19",
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "CPAN::Meta::Check" => "0.011",
    "CPAN::Meta::Requirements" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "IPC::System::Simple" => 0,
    "Storable" => 0,
    "Test::Fatal" => 0,
    "Test::File::ShareDir::Dist" => 0,
    "Test::More" => "0.96",
    "Test::Requires" => 0,
    "Test::Warnings" => 0,
    "base" => 0,
    "utf8" => 0
  },
  "VERSION" => "1.22",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "CPAN::Meta::Check" => "0.011",
  "CPAN::Meta::Requirements" => 0,
  "Carp" => 0,
  "Dist::CheckConflicts" => "0.02",
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::ShareDir" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "IPC::System::Simple" => 0,
  "List::Util" => "1.45",
  "Params::ValidationCompiler" => "0.13",
  "Specio::Declare" => 0,
  "Specio::Library::String" => 0,
  "Storable" => 0,
  "Test::Fatal" => 0,
  "Test::File::ShareDir::Dist" => 0,
  "Test::More" => "0.96",
  "Test::Requires" => 0,
  "Test::Warnings" => 0,
  "base" => 0,
  "namespace::autoclean" => "0.19",
  "strict" => 0,
  "utf8" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}

sub check_conflicts {
    if ( eval { require './lib/DateTime/Locale/Conflicts.pm'; 1; } ) {
        if ( eval { DateTime::Locale::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually by examining the list of conflicts in DateTime::Locale::Conflicts once the installation
    finishes.
***
EOF
    }

    return if $ENV{AUTOMATED_TESTING} || $ENV{NONINTERACTIVE_TESTING};

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
