/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef IMPRESOURCEDIR_H_INCLUDED
#define IMPRESOURCEDIR_H_INCLUDED

#include <boost/shared_ptr.hpp>


namespace libebook
{

class IMPHeader;
class IMPResourceDirImpl;

/** Read the resource tree and provide access to it as an OLE stream.
  */
class IMPResourceDir
{
public:
  IMPResourceDir(librevenge::RVNGInputStream *input, const IMPHeader &header);

  /** Get OLE stream for this resource directory.
    *
    * The "files" in the stream are referenced by their names (i.e.,
    * random four-letter strings)..
    *
    * @return OLE stream
    */
  boost::shared_ptr<librevenge::RVNGInputStream> getNameStream() const;

  /** Get OLE stream for this resource directory.
    *
    * The "files" in the stream are referenced by their type.
    *
    * @return OLE stream
    */
  boost::shared_ptr<librevenge::RVNGInputStream> getTypeStream() const;

private:
  boost::shared_ptr<IMPResourceDirImpl> m_impl;
};

}

#endif // IMPRESOURCEDIR_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
