/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import junit.framework.TestCase;

public class ContentTypeTest extends TestCase {
	
	public void testIt() {
		ContentType ct = ContentType.parse("text/plain");
		assertEquals("text", ct.getType());
		assertEquals("plain", ct.getSubtype());
		ct = ContentType.parse("TEXT/plain");
		assertEquals("text", ct.getType());
		ct = ContentType.parse("x-foo/plain");
		assertEquals("x-foo", ct.getType());
		assertEquals(null, ct.getParameter("x"));
		assertEquals(null, ct.getParameterValue("x"));
		ct = ContentType.parse("X-foo/plain");
		assertEquals("x-foo", ct.getType());
	}
	
	public void testCheck() {
		ContentType.checkToken("ok");
		try {
    		ContentType.checkToken("\b");
    		fail("invalid");
		} catch (IllegalArgumentException e) {}
	}
	
	public void testInvalid() {
		try {
    		new ContentType(null, null);
    		fail("bad");
		} catch (NullPointerException e) {}
		try {
    		new ContentType("text", null);
    		fail("bad");
		} catch (NullPointerException e) {}
		try {
    		ContentType.parse("bad/plain");
    		fail("bad");
		} catch (IllegalArgumentException e) {}
		try {
    		ContentType.parse("noslash");
    		fail("bad");
		} catch (IllegalArgumentException e) {}
		try {
    		ContentType.parse("text/\b");
    		fail("bad");
		} catch (IllegalArgumentException e) {}
		try {
    		ContentType.parse("text/\u2222");
    		fail("bad");
		} catch (IllegalArgumentException e) {}
		try {
    		ContentType.parse("text/plain; foo");
    		fail("bad");
		} catch (IllegalArgumentException e) {}
		try {
    		ContentType.parse("text/plain; \u2222=bar");
    		fail("bad");
		} catch (IllegalArgumentException e) {}
		try {
    		ContentType.parse("x-\u2222/plain");
    		fail("bad");
		} catch (IllegalArgumentException e) {}
		try {
			new ContentType.Parameter(null, null);
    		fail("bad");
		} catch (NullPointerException e) {}
		try {
			new ContentType.Parameter("x", null);
    		fail("bad");
		} catch (NullPointerException e) {}
	}
		
	public void testParams() {
		ContentType ct;
		ct = ContentType.parse("text/plain; foo=bar; baz=\"biz\"");
		assertEquals("text/plain;foo=bar;baz=biz", ct.toString());
		ct = ContentType.parse("text/plain; baz=\"b\\\"iz\"");
		assertEquals("text/plain;baz=\"b\\\"iz\"", ct.toString());
		ct = ContentType.parse("texT/plain; baz=\"sp \\ace\"");
		assertEquals("sp ace", ct.getParameters().get(0).getValue());
		ct = ContentType.parse("texT/plain; baz=\";\"; a=b");
		assertEquals(";", ct.getParameters().get(0).getValue());
		assertEquals("b", ct.getParameters().get(1).getValue());
		assertEquals("b", ct.getParameterValue("a"));
		assertEquals("a=b", ct.getParameter("a").toString());
		ContentType.Parameter p = new ContentType.Parameter("x", "\r \t\"");
		assertEquals("x=\"\r \t\\\"\"", p.toString());
		p = new ContentType.Parameter("x", "\";\"");
		assertEquals("x=\"\\\";\\\"\"", p.toString());
		p = new ContentType.Parameter("x", "\\");
		assertEquals("\"\\\"", p.getQuoteValue());
	}

}
