'\" t
.\"
.\" libexplain - Explain errno values returned by libc functions
.\" Copyright (C) 2008-2010 Peter Miller
.\" Written by Peter Miller <pmiller@opensource.org.au>
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program. If not, see <http://www.gnu.org/licenses/>.
.\"
.\"
.TH Build libexplain libexplain "Reference Manual"
.so etc/version.so
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.SH NAME
How to build libexplain
.XX "" "How to build libexplain"
.SH SPACE REQUIREMENTS
You will need about 6MB to unpack and build the
\f[I]libexplain\fP package.  Your milage may vary.
.br
.ne 1i
.SH BEFORE YOU START
There are a few pieces of software you may want to
fetch and install before you proceed with your installation of libexplain
.TP 8n
libcap
Linux needs libcap, for access to capabilities.
.br
ftp://ftp.kernel.org/pub/linux/libs/security/linux\-privs/kernel\-2.2/
.TP 8n
lsof
.RS
For systems with inadequate or non\[hy]existent /proc facilities, and that
includes *BSD and MacOS X, the \f[I]lsof\fP(1) program is needed to
obtain supplementary information about open file descriptors.  However,
if \f[I]lsof\fP(1) is not supported on your operating system, libexplain
will still work, but some useful information (such as translating file
descriptors into the name of the open file) will be absent from error
explanations.
.PP
ftp://lsof.itap.purdue.edu/pub/tools/unix/lsof/
.br
http://people.freebsd.org/~abe/
.PP
You \f[B]must\fP have \f[I]lsof\fP(1) installed on *BSD and Solaris,
otherwise the test suite will generate staggering numbers of false
negatives.  It will produce less informative error messages, too.
.PP
Supported systems include:
Free BSD,
HP/UX,
Linux,
Mac OS X,
NetBSD,
Open BSD,
Solaris,
and several others.
.RE
.TP 8n
GNU libtool
The libtool program is used to build shared libraries.  It understands
the neccesary, weird and wonderful compiler and linker tricks on many weird
and wonderful systems.
.br
http://www.gnu.org/software/libtool/
.TP 8n
bison
The bison program is a general\[hy]purpose parser generator that converts a
grammar description for an LALR(1) context\[hy]free grammar into a C program
to parse that grammar.
.br
http://www.gnu.org/software/bison/
.TP 8n
GNU Groff
The documentation for the \f[I]libexplain\fP package was prepared using
the GNU Groff package (version 1.14 or later).  This distribution
includes full documentation, which may be processed into PostScript or
DVI files at install time \- if GNU Groff has been installed.
.TP 8n
GCC
You may also want to consider fetching and installing the GNU C Compiler
if you have not done so already.  This is not essential.
libexplain was developed using the GNU C compiler, and the GNU C libraries.
.PP
The GNU FTP archives may be found at \f[CW]ftp.gnu.org\fP,
and are mirrored around the world.
.br
.ne 1i
.SH SITE CONFIGURATION
The
.B libexplain
package is configured using the
.I configure
program included in this distribution.
.PP
The
.I configure
shell script attempts to guess correct values for
various system\[hy]dependent variables used during compilation,
and creates the
.I Makefile
and
.I libexplain/config.h
files.
It also creates a shell script
.I config.status
that you can run in the future to recreate the current configuration.
.PP
Normally,
you just
.I cd
to the directory containing
.IR libexplain "'s"
source code and then type
.RS
.ft CW
.nf
\f[B]% \fP./configure
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
If you're using
.I csh
on an old version of System V,
you might need to type
.RS
.ft CW
.nf
\f[B]% \f[P]sh configure
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
instead to prevent
.I csh
from trying to execute
.I configure
itself.
.PP
Running
.I configure
takes a minute or two.
While it is running,
it prints some messages that tell what it is doing.
If you don't want to see the messages,
run
.I configure
using the quiet option;
for example,
.RS
.FT CW
.nf
\f[B]% \fP./configure \-\-quiet
\bB%\fP
.fi
.ft R
.RE
.PP
To compile the
.B libexplain
package in a different directory from the one
containing the source code,
you must use a version of
.I make
that supports the
.I VPATH variable,
such as
.IR "GNU make" .
.I cd
to the directory where you want the object files and executables to go and run
the
.I configure
script.
.I configure
automatically checks for the source code in the directory that
.I configure
is in and in
.IR \&..
(the parent directory).
If for some reason
.I configure
is not in the source code directory that you are configuring,
then it will report that it can't find the source code.
In that case,
run
.I configure
with the option \f[CW]\-\-srcdir=\fP\f[I]DIR\fP,
where
.I DIR
is the directory that contains the source code.
.PP
By default,
.I configure
will arrange for the
.I "make install"
command to install the
.B libexplain
package's files in
.IR /usr/local/bin ,
.IR /usr/local/lib ,
.IR /usr/local/include ,
and
.IR /usr/local/man .
There are options which allow you to control the placement
of these files.
.TP 8n
\f[CW]\-\-prefix=\fP\f[I]PATH\fP
This specifies the path prefix to be used in the installation.
Defaults to \f[I]/usr/local\fP unless otherwise specified.
.TP 8n
\f[CW]\-\-exec\-prefix=\fP\f[I]PATH\fP
You can specify separate installation prefixes for
architecture\[hy]specific files files.
Defaults to \f[I]${prefix}\fP unless otherwise specified.
.TP 8n
\f[CW]\-\-bindir=\fP\f[I]PATH\fP
This directory contains executable programs.  On a network, this
directory may be shared between machines with identical hardware and
operating systems; it may be mounted read\[hy]only.  Defaults to
\f[I]${exec_prefix}/bin\fP unless otherwise specified.
.TP 8n
\f[CW]\-\-mandir=\fP\f[I]PATH\fP
This directory contains the on\[hy]line manual entries.  On a network, this
directory may be shared between all machines; it may be mounted
read\[hy]only.  Defaults to \f[I]${prefix}/man\fP unless otherwise specified.
.PP
.I configure
ignores most other arguments that you give it;
use the \f[CW]\-\-help\fP option for a complete list.
.br
.ne 2i
.PP
On systems that require unusual options for compilation or linking
that the
.I libexplain
package's
.I configure
script does not know about,
you can give
.I configure
initial values for variables by setting them in the environment.
In Bourne\[hy]compatible shells,
you can do that on the command line like this:
.RS
.ft CW
.nf
\f[B]$ \f[P]CC='gcc \-ansi' LIBS=\-lposix ./configure
\f[I]\&...lots of output...\fP
\f[B]$\fP
.fi
.ft R
.RE
Here are the
.I make
variables that you might want to override with
environment variables when running
.IR configure .
.TP 8n
Variable: CC
C compiler program.
The default is
.IR gcc .
.TP 8n
Variable: CPPFLAGS
Preprocessor flags, commonly defines and include search paths.
Defaults to empty.
It is common to use \f[CW]CPPFLAGS=\-I/usr/local/include\fP to access other
installed packages.
.TP 8n
Variable: INSTALL
Program to use to install files.
The default is
.I install
if you have it,
.I cp
otherwise.
.TP 8n
Variable: LIBS
Libraries to link with,
in the form \f[CW]\-l\fP\f[I]foo\fP \f[CW]\-l\fP\f[I]bar\fP.
The
.I configure
script will append to this,
rather than replace it.
It is common to use \f[CW]LIBS=\-L/usr/local/lib\fP to access other
installed packages.
.PP
If you need to do unusual things to compile the package,
the author encourages you to figure out how
.I configure
could check whether to do them,
and mail diffs or instructions to the author
so that they can be included in the next release.
.br
.ne 1i
.SH BUILDING LIBEXPLAIN
All you should need to do is use the
.RS
.ft CW
.nf
\f[B]% \f[P]make
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command and wait.
This can take a long time, as there are a few thousand files to be compiled.
.PP
You can remove the program binaries and object files from the
source directory by using the
.RS
.ft CW
.nf
\f[B]% \f[P]make clean
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.
To remove all of the above files, and also remove the
.I Makefile
and
.I libexplain/config.h
and
.I config.status
files, use the
.RS
.ft CW
.nf
\f[B]% \f[P]make distclean
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.
.PP
The file
.I etc/configure.ac
is used to create
.I configure
by a GNU program called
.IR autoconf .
You only need to know this if you want to regenerate
.I configure
using a newer version of
.IR autoconf .
.br
.ne 1i
.SH TESTING LIBEXPLAIN
The
.I libexplain
package comes with a test suite.
To run this test suite, use the command
.RS
.ft CW
.nf
\f[B]% \f[P]make sure
\f[I]\&...lots of output...\fP
.if n \f[B]Passed All Tests\fP
.if t \f[CB]Passed All Tests\fP
\f[B]%\fP
.fi
.ft R
.RE
.PP
The tests take a fraction of a second each,
with most very fast,
and a couple very slow,
but it varies greatly depending on your CPU.
.PP
If all went well, the message
.RS
.ft CW
Passed All Tests
.ft R
.RE
should appear at the end of the make.
.SS Sources of False Negatives
There are a number of factors that can cause tests to fail unnecessarily.
.TP 8n
Root
You will get false negatives if you run the tests as root.
.TP
Architecture
Some errors move around depending on architecture (sparc vs x86 vs s390,
\f[I]etc\fP).  Some even move around due to different memory layout for
32\[hy]but \f[I]vs\fP 64\[hy]bit, for the same processor family.  For
example, when testing EFAULT explanations.
.TP
strerror
Different systems have different \f[I]strerror\fP(3) implementations
(the numbers vary, the texts vary, the existence varies, \f[I]etc\fP).
This can even be incompatible across Linux architectures when ABI
compatibility was the goal, \f[I]e.g.\fP sparc \f[I]vs\fP i386.
.TP
ioctl
There are (at least) three inconsistent implementations of ioctl request
macros, all incompatible, depending on Unix vendor.  They also vary on
Linux, depending on architecture, for ABI compatibility reasons.
.TP
Environment
Some tests are difficult because the build\[hy]and\[hy]test environment
can vary widely.  Sometimes it's a chroot, sometimes it's a VM,
sometimes it's fakeroot, sometimes it really is running as root.  All
these affect the ability of the library to probe the system looking for
the proximal cause of the error, \f[I]e.g.\fP ENOSPC or EROFS.
This often results in 2 or 4 or 8 explanations of an error, depending
on what the library finds, e.g. existence of useful information in the
mount table, or not.
.TP
Mount Table
If you run the tests in a chroot jail build environment, maybe with
bind mounts for the file systems, it is necessary to make sure
\f[I]/etc/mtab\fP (or equivalent) has sensable contents, otherwise some
of the path resolution tests will return false negatives.
.TP
/proc
If your system has a completely inadequate \f[CW]/proc\fP implementation
(including, but not limited to: *BSD, Mac OS X, and Solaris)
or no \f[CW]/proc\fP at all,
\f[B]and\fP you have not installed the \f[I]lsof\fP(1) tool,
then most of the tests will return false negatives.
.PP
As these problem have occured, many of the tests have been enhanced to cope,
but not all false negative situations have yet been discovered.
.br
.ne 1i
.SH INSTALLING LIBEXPLAIN
As explained in the
.I "SITE CONFIGURATION"
section, above,
the
.I libexplain
package is installed under the
.I /usr/local
tree by default.
Use the \f[CW]\-\-prefix=\fP\f[I]PATH\fP option to
.I configure
if you want some other path.
More specific installation locations are assignable,
use the \f[CW]\-\-help\fP option to
.I configure
for details.
.PP
All that is required to install the
.I libexplain
package is to use the
.RS
.ft CW
.nf
\f[B]% \f[P]make install
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.
Control of the directories used may be found in the first
few lines of the
.I Makefile
file and the other files written by the
.I configure
script;
it is best to reconfigure using the
.I configure
script, rather than attempting to do this by hand.
.br
.ne 1i
.SH GETTING HELP
If you need assistance with the
.I libexplain
package,
please do not hesitate to contact the author at
.RS
.ft CW
Peter Miller <pmiller@opensource.org.au>
.ft R
.RE
Any and all feedback is welcome.
.PP
When reporting problems,
please include the version number
given by the
.RS
.ft CW
.nf
\f[B]% \f[P]explain \-version
.if n \f[B]explain version\fP \f[I]\*(V)\fP
.if t \f[CB]explain version\fP \f[I]\*(V)\fP
\f[I]\&...warranty disclaimer...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.
Please do not send this example;
run the program for the exact version number.
.br
.ne 2i
.SH COPYRIGHT
.I libexplain
version \*(v)
.br
Copyright
.if n (C)
.if t \(co
\*(Y) Peter Miller
.PP
The
.I libexplain
package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Lesseir General Public License for more details.
.PP
It should be in the
.I LICENSE
file included with this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l r l.
Peter Miller;E\[hy]Mail:;pmiller@opensource.org.au
\f[CW]/\e/\e*\fP;WWW:;http://www.canb.auug.org.au/~millerp/
.TE
