/*
 *      fm-path-entry.h
 *      
 *      Copyright 2009 PCMan <pcman.tw@gmail.com>
 *      Copyright 2009 Jürgen Hötzel <juergen@archlinux.org>
 *      
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *      
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *      
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


#ifndef __FM_PATH_ENTRY_H__
#define __FM_PATH_ENTRY_H__

#include <gtk/gtk.h>
#include <gio/gio.h>

/* required for completion */
#include "fm-folder-model.h"

G_BEGIN_DECLS

#define FM_TYPE_PATH_ENTRY (fm_path_entry_get_type())
#define FM_PATH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), FM_TYPE_PATH_ENTRY, FmPathEntry))
#define FM_PATH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), FM_TYPE_PATH_ENTRY, FmPathEntryClass))
#define IS_FM_TYPE_PATH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FM_TYPE_PATH_ENTRY))
#define IS_FM_TYPE_PATH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FM_TYPE_PATH_ENTRY), FmPathEntry)

typedef struct _FmPathEntry	FmPathEntry;
typedef struct _FmPathEntryClass FmPathEntryClass;

struct _FmPathEntry 
{
  GtkEntry parent_instance;
};

struct _FmPathEntryClass
{
  GtkEntryClass parent_class;
};

GType fm_path_entry_get_type(void);
GtkWidget* fm_path_entry_new();
void fm_path_entry_set_model(FmPathEntry *entry, FmPath* path, FmFolderModel* model);


G_END_DECLS

#endif /* __FM_PATH_ENTRY_H__ */
