/* process.c generated by valac 0.14.2, the Vala compiler
 * generated from process.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include <gio/gio.h>
#include <sys/wait.h>
#include <float.h>
#include <math.h>


#define FSO_FRAMEWORK_TYPE_IPROCESS_GUARD (fso_framework_iprocess_guard_get_type ())
#define FSO_FRAMEWORK_IPROCESS_GUARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_IPROCESS_GUARD, FsoFrameworkIProcessGuard))
#define FSO_FRAMEWORK_IS_IPROCESS_GUARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_IPROCESS_GUARD))
#define FSO_FRAMEWORK_IPROCESS_GUARD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_IPROCESS_GUARD, FsoFrameworkIProcessGuardIface))

typedef struct _FsoFrameworkIProcessGuard FsoFrameworkIProcessGuard;
typedef struct _FsoFrameworkIProcessGuardIface FsoFrameworkIProcessGuardIface;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FSO_FRAMEWORK_TYPE_GPROCESS_GUARD (fso_framework_gprocess_guard_get_type ())
#define FSO_FRAMEWORK_GPROCESS_GUARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_GPROCESS_GUARD, FsoFrameworkGProcessGuard))
#define FSO_FRAMEWORK_GPROCESS_GUARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_GPROCESS_GUARD, FsoFrameworkGProcessGuardClass))
#define FSO_FRAMEWORK_IS_GPROCESS_GUARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_GPROCESS_GUARD))
#define FSO_FRAMEWORK_IS_GPROCESS_GUARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_GPROCESS_GUARD))
#define FSO_FRAMEWORK_GPROCESS_GUARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_GPROCESS_GUARD, FsoFrameworkGProcessGuardClass))

typedef struct _FsoFrameworkGProcessGuard FsoFrameworkGProcessGuard;
typedef struct _FsoFrameworkGProcessGuardClass FsoFrameworkGProcessGuardClass;
typedef struct _FsoFrameworkGProcessGuardPrivate FsoFrameworkGProcessGuardPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _FsoFrameworkGprocessGuardStopData FsoFrameworkGprocessGuardStopData;

#define TYPE_ASYNC_PROCESS (async_process_get_type ())
#define ASYNC_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_PROCESS, AsyncProcess))
#define ASYNC_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_PROCESS, AsyncProcessClass))
#define IS_ASYNC_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_PROCESS))
#define IS_ASYNC_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_PROCESS))
#define ASYNC_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_PROCESS, AsyncProcessClass))

typedef struct _AsyncProcess AsyncProcess;
typedef struct _AsyncProcessClass AsyncProcessClass;
typedef struct _AsyncProcessPrivate AsyncProcessPrivate;
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
typedef struct _AsyncProcessLaunchData AsyncProcessLaunchData;
typedef struct _async_process_onCancelAsyncData async_process_onCancelAsyncData;

struct _FsoFrameworkIProcessGuardIface {
	GTypeInterface parent_iface;
	gboolean (*launch) (FsoFrameworkIProcessGuard* self, gchar** command, int command_length1);
	void (*stop) (FsoFrameworkIProcessGuard* self, gint sig);
	void (*setAutoRelaunch) (FsoFrameworkIProcessGuard* self, gboolean on);
	gboolean (*sendSignal) (FsoFrameworkIProcessGuard* self, gint sig);
	gboolean (*isRunning) (FsoFrameworkIProcessGuard* self);
};

struct _FsoFrameworkGProcessGuard {
	GObject parent_instance;
	FsoFrameworkGProcessGuardPrivate * priv;
};

struct _FsoFrameworkGProcessGuardClass {
	GObjectClass parent_class;
};

struct _FsoFrameworkGProcessGuardPrivate {
	GPid pid;
	guint watch;
	gchar** command;
	gint command_length1;
	gint _command_size_;
	gboolean relaunch;
};

struct _FsoFrameworkGprocessGuardStopData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoFrameworkGProcessGuard* self;
	gboolean send;
	GPid _tmp0_;
	GPid _tmp1_;
	gboolean done;
	GTimer* _tmp2_;
	GTimer* timer;
	GTimer* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GPid _tmp6_;
	gboolean _tmp7_;
	GPid _tmp8_;
	pid_t _tmp9_;
	pid_t pid_result;
	pid_t _tmp10_;
	pid_t _tmp11_;
	GTimer* _tmp12_;
	gdouble _tmp13_;
	GPid _tmp14_;
	GPid _tmp15_;
	GPid _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	GPid _tmp19_;
	gboolean _tmp20_;
};

struct _AsyncProcess {
	GObject parent_instance;
	AsyncProcessPrivate * priv;
};

struct _AsyncProcessClass {
	GObjectClass parent_class;
};

struct _AsyncProcessPrivate {
	GIOFunc stdout_watch;
	gpointer stdout_watch_target;
	GDestroyNotify stdout_watch_target_destroy_notify;
	GIOFlags stdout_flags;
	GIOCondition stdout_condition;
	GIOFunc stderr_watch;
	gpointer stderr_watch_target;
	GDestroyNotify stderr_watch_target_destroy_notify;
	GIOFlags stderr_flags;
	GIOCondition stderr_condition;
	gchar* _cmd_line;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GPid pid;
	gint _std_in;
	gint std_out;
	gint std_err;
	GIOChannel* err_channel;
	GIOChannel* out_channel;
	gint status;
	guint child;
};

struct _AsyncProcessLaunchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AsyncProcess* self;
	GCancellable* cancel;
	gchar** argv;
	gint argv_length1;
	gint result;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GPid _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GIOFunc _tmp13_;
	void* _tmp13__target;
	gint _tmp14_;
	GIOChannel* _tmp15_;
	GIOChannel* _tmp16_;
	GIOFlags _tmp17_;
	GError* e1;
	GError* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GIOChannel* _tmp23_;
	GIOCondition _tmp24_;
	GIOFunc _tmp25_;
	void* _tmp25__target;
	GIOFunc _tmp26_;
	void* _tmp26__target;
	gint _tmp27_;
	GIOChannel* _tmp28_;
	GIOChannel* _tmp29_;
	GIOFlags _tmp30_;
	GError* e2;
	GError* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GIOChannel* _tmp36_;
	GIOCondition _tmp37_;
	GIOFunc _tmp38_;
	void* _tmp38__target;
	GPid _tmp39_;
	guint _tmp40_;
	GCancellable* _tmp41_;
	GCancellable* _tmp42_;
	gint _tmp43_;
	GError * _inner_error_;
};

struct _async_process_onCancelAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AsyncProcess* self;
	gint i;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GPid _tmp4_;
	GPid _tmp5_;
	GPid _tmp6_;
	GPid _tmp7_;
};


static gpointer fso_framework_gprocess_guard_parent_class = NULL;
static FsoFrameworkIProcessGuardIface* fso_framework_gprocess_guard_fso_framework_iprocess_guard_parent_iface = NULL;
static gpointer async_process_parent_class = NULL;

GType fso_framework_iprocess_guard_get_type (void) G_GNUC_CONST;
gboolean fso_framework_iprocess_guard_launch (FsoFrameworkIProcessGuard* self, gchar** command, int command_length1);
void fso_framework_iprocess_guard_stop (FsoFrameworkIProcessGuard* self, gint sig);
void fso_framework_iprocess_guard_setAutoRelaunch (FsoFrameworkIProcessGuard* self, gboolean on);
gboolean fso_framework_iprocess_guard_sendSignal (FsoFrameworkIProcessGuard* self, gint sig);
gboolean fso_framework_iprocess_guard_isRunning (FsoFrameworkIProcessGuard* self);
#define FSO_FRAMEWORK_PROCESS_PROC_PATH "/proc"
pid_t fso_framework_process_findByName (const gchar* name);
gchar** fso_framework_file_handling_listDirectory (const gchar* dirname, int* result_length1);
gboolean fso_framework_file_handling_isPresent (const gchar* filename);
gchar* fso_framework_file_handling_read (const gchar* filename);
GType fso_framework_gprocess_guard_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_GPROCESS_GUARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_GPROCESS_GUARD, FsoFrameworkGProcessGuardPrivate))
enum  {
	FSO_FRAMEWORK_GPROCESS_GUARD_DUMMY_PROPERTY
};
static void fso_framework_gprocess_guard_syncStop (FsoFrameworkGProcessGuard* self);
#define FSO_FRAMEWORK_GPROCESS_GUARD_KILL_SLEEP_TIMEOUT ((1000 * 1000) * 5)
#define FSO_FRAMEWORK_GPROCESS_GUARD_KILL_SLEEP_INTERVAL ((1000 * 1000) * 1)
pid_t _fso_framework_gprocess_guard_pid (FsoFrameworkGProcessGuard* self);
gboolean fso_framework_gprocess_guard_attach (FsoFrameworkGProcessGuard* self, pid_t pid, gchar** command, int command_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void fso_framework_gprocess_guard_onChildWatchEvent (FsoFrameworkGProcessGuard* self, GPid pid, gint status);
static void _fso_framework_gprocess_guard_onChildWatchEvent_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean fso_framework_gprocess_guard_real_launch (FsoFrameworkIProcessGuard* base, gchar** command, int command_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gboolean fso_framework_gprocess_guard_launchWithPipes (FsoFrameworkGProcessGuard* self, gchar** command, int command_length1, gint* fdin, gint* fdout);
static gchar** _vala_array_dup5 (gchar** self, int length);
static void fso_framework_gprocess_guard_real_stop (FsoFrameworkIProcessGuard* base, gint sig);
static void fso_framework_gprocess_guard_stopSendStopped (FsoFrameworkGProcessGuard* self, gboolean send);
static void fso_framework_gprocess_guard_real_setAutoRelaunch (FsoFrameworkIProcessGuard* base, gboolean on);
static gboolean fso_framework_gprocess_guard_real_sendSignal (FsoFrameworkIProcessGuard* base, gint sig);
static gboolean fso_framework_gprocess_guard_real_isRunning (FsoFrameworkIProcessGuard* base);
static void _fso_framework_gprocess_guard_stop (FsoFrameworkGProcessGuard* self, gboolean send, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _fso_framework_gprocess_guard_stop_finish (FsoFrameworkGProcessGuard* self, GAsyncResult* _res_);
static void fso_framework_gprocess_guard_cleanupResources (FsoFrameworkGProcessGuard* self);
static void _fso_framework_gprocess_guard_stop_data_free (gpointer _data);
static gboolean _fso_framework_gprocess_guard_stop_co (FsoFrameworkGprocessGuardStopData* _data_);
static gboolean __fso_framework_gprocess_guard_stop_co_gsource_func (gpointer self);
FsoFrameworkGProcessGuard* fso_framework_gprocess_guard_new (void);
FsoFrameworkGProcessGuard* fso_framework_gprocess_guard_construct (GType object_type);
static void fso_framework_gprocess_guard_finalize (GObject* obj);
GType async_process_get_type (void) G_GNUC_CONST;
#define ASYNC_PROCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASYNC_PROCESS, AsyncProcessPrivate))
enum  {
	ASYNC_PROCESS_DUMMY_PROPERTY,
	ASYNC_PROCESS_STD_IN,
	ASYNC_PROCESS_CMD_LINE
};
#define ASYNC_PROCESS_NUM_FRIENDLY_KILLS 5
void async_process_set_stdout_watch (AsyncProcess* self, GIOFunc watch, void* watch_target, GIOCondition cond, GIOFlags flags);
void async_process_set_stderr_watch (AsyncProcess* self, GIOFunc watch, void* watch_target, GIOCondition cond, GIOFlags flags);
static void async_process_launch_data_free (gpointer _data);
static gchar** _vala_array_dup6 (gchar** self, int length);
void async_process_launch (AsyncProcess* self, GCancellable* cancel, gchar** argv, int argv_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gint async_process_launch_finish (AsyncProcess* self, GAsyncResult* _res_, GError** error);
static gboolean async_process_launch_co (AsyncProcessLaunchData* _data_);
static gchar** _vala_array_dup7 (gchar** self, int length);
static void async_process_onExit (AsyncProcess* self, GPid p, gint status);
static void _async_process_onExit_gchild_watch_func (GPid pid, gint status, gpointer self);
static void async_process_onCancel (AsyncProcess* self);
static void _async_process_onCancel_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static gboolean _async_process_launch_co_gsource_func (gpointer self);
static void async_process_onCancelAsync (AsyncProcess* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void async_process_onCancelAsync_finish (AsyncProcess* self, GAsyncResult* _res_);
static void async_process_onCancelAsync_data_free (gpointer _data);
static gboolean async_process_onCancelAsync_co (async_process_onCancelAsyncData* _data_);
void fso_framework_async_sleep_async (gint timeout, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_async_sleep_finish (GAsyncResult* _res_);
static void async_process_onCancelAsync_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
AsyncProcess* async_process_new (void);
AsyncProcess* async_process_construct (GType object_type);
gint async_process_get_std_in (AsyncProcess* self);
const gchar* async_process_get_cmd_line (AsyncProcess* self);
static void async_process_finalize (GObject* obj);
static void _vala_async_process_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gboolean fso_framework_iprocess_guard_launch (FsoFrameworkIProcessGuard* self, gchar** command, int command_length1) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_IPROCESS_GUARD_GET_INTERFACE (self)->launch (self, command, command_length1);
}


void fso_framework_iprocess_guard_stop (FsoFrameworkIProcessGuard* self, gint sig) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_IPROCESS_GUARD_GET_INTERFACE (self)->stop (self, sig);
}


void fso_framework_iprocess_guard_setAutoRelaunch (FsoFrameworkIProcessGuard* self, gboolean on) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_IPROCESS_GUARD_GET_INTERFACE (self)->setAutoRelaunch (self, on);
}


gboolean fso_framework_iprocess_guard_sendSignal (FsoFrameworkIProcessGuard* self, gint sig) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_IPROCESS_GUARD_GET_INTERFACE (self)->sendSignal (self, sig);
}


gboolean fso_framework_iprocess_guard_isRunning (FsoFrameworkIProcessGuard* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_IPROCESS_GUARD_GET_INTERFACE (self)->isRunning (self);
}


static void fso_framework_iprocess_guard_base_init (FsoFrameworkIProcessGuardIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("running", FSO_FRAMEWORK_TYPE_IPROCESS_GUARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("stopped", FSO_FRAMEWORK_TYPE_IPROCESS_GUARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


/**
 * @interface FsoFramework.IProcessGuard
 **/
GType fso_framework_iprocess_guard_get_type (void) {
	static volatile gsize fso_framework_iprocess_guard_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_iprocess_guard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkIProcessGuardIface), (GBaseInitFunc) fso_framework_iprocess_guard_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType fso_framework_iprocess_guard_type_id;
		fso_framework_iprocess_guard_type_id = g_type_register_static (G_TYPE_INTERFACE, "FsoFrameworkIProcessGuard", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (fso_framework_iprocess_guard_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&fso_framework_iprocess_guard_type_id__volatile, fso_framework_iprocess_guard_type_id);
	}
	return fso_framework_iprocess_guard_type_id__volatile;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


pid_t fso_framework_process_findByName (const gchar* name) {
	pid_t result = 0;
	gint _result_;
	gint pid;
	gchar* statfile = NULL;
	gchar* pstat = NULL;
	gchar* pname = NULL;
	gchar** stat_info = NULL;
	gint stat_info_length1 = 0;
	gint _stat_info_size_ = 0;
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gchar** subdirs;
	gint subdirs_length1;
	gint _subdirs_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp37_;
	g_return_val_if_fail (name != NULL, 0);
	_result_ = 0;
	pid = 0;
	_tmp1_ = fso_framework_file_handling_listDirectory (FSO_FRAMEWORK_PROCESS_PROC_PATH, &_tmp0_);
	subdirs = _tmp1_;
	subdirs_length1 = _tmp0_;
	_subdirs_size_ = subdirs_length1;
	_tmp2_ = subdirs;
	_tmp2__length1 = subdirs_length1;
	{
		gchar** dirname_collection = NULL;
		gint dirname_collection_length1 = 0;
		gint _dirname_collection_size_ = 0;
		gint dirname_it = 0;
		dirname_collection = _tmp2_;
		dirname_collection_length1 = _tmp2__length1;
		for (dirname_it = 0; dirname_it < _tmp2__length1; dirname_it = dirname_it + 1) {
			gchar* _tmp3_;
			gchar* dirname = NULL;
			_tmp3_ = g_strdup (dirname_collection[dirname_it]);
			dirname = _tmp3_;
			{
				const gchar* _tmp4_;
				gint _tmp5_ = 0;
				gint _tmp6_;
				const gchar* _tmp7_ = NULL;
				gint _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				const gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				const gchar* _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				gchar** _tmp20_;
				gint _tmp20__length1;
				gboolean _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gchar* _tmp32_ = NULL;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gboolean _tmp35_ = FALSE;
				_tmp4_ = dirname;
				_tmp5_ = atoi (_tmp4_);
				pid = _tmp5_;
				_tmp6_ = pid;
				if (_tmp6_ <= 0) {
					_g_free0 (dirname);
					continue;
				}
				_tmp7_ = string_to_string (FSO_FRAMEWORK_PROCESS_PROC_PATH);
				_tmp8_ = pid;
				_tmp9_ = g_strdup_printf ("%i", _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp7_, "/", _tmp10_, "/stat", NULL);
				_g_free0 (statfile);
				statfile = _tmp11_;
				_g_free0 (_tmp10_);
				_tmp12_ = statfile;
				_tmp13_ = fso_framework_file_handling_isPresent (_tmp12_);
				if (!_tmp13_) {
					_g_free0 (dirname);
					continue;
				}
				_tmp14_ = statfile;
				_tmp15_ = fso_framework_file_handling_read (_tmp14_);
				_g_free0 (pstat);
				pstat = _tmp15_;
				_tmp16_ = pstat;
				_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, " ", 0);
				stat_info = (_vala_array_free (stat_info, stat_info_length1, (GDestroyNotify) g_free), NULL);
				stat_info = _tmp18_;
				stat_info_length1 = _vala_array_length (_tmp17_);
				_stat_info_size_ = stat_info_length1;
				_tmp20_ = stat_info;
				_tmp20__length1 = stat_info_length1;
				if (!(_tmp20__length1 >= 2)) {
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					_tmp21_ = stat_info;
					_tmp21__length1 = stat_info_length1;
					_tmp22_ = _tmp21_[1];
					_tmp23_ = strlen (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp19_ = _tmp24_ > 2;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp25_ = _tmp19_;
				if (_tmp25_) {
					_g_free0 (dirname);
					continue;
				}
				_tmp26_ = stat_info;
				_tmp26__length1 = stat_info_length1;
				_tmp27_ = _tmp26_[1];
				_tmp28_ = stat_info;
				_tmp28__length1 = stat_info_length1;
				_tmp29_ = _tmp28_[1];
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = string_slice (_tmp27_, (glong) 1, (glong) (_tmp31_ - 2));
				_g_free0 (pname);
				pname = _tmp32_;
				_tmp33_ = name;
				_tmp34_ = pname;
				_tmp35_ = g_str_has_prefix (_tmp33_, _tmp34_);
				if (_tmp35_) {
					gint _tmp36_;
					_tmp36_ = pid;
					_result_ = _tmp36_;
					_g_free0 (dirname);
					break;
				}
				_g_free0 (dirname);
			}
		}
	}
	_tmp37_ = _result_;
	result = (pid_t) _tmp37_;
	subdirs = (_vala_array_free (subdirs, subdirs_length1, (GDestroyNotify) g_free), NULL);
	stat_info = (_vala_array_free (stat_info, stat_info_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (pname);
	_g_free0 (pstat);
	_g_free0 (statfile);
	return result;
}


pid_t _fso_framework_gprocess_guard_pid (FsoFrameworkGProcessGuard* self) {
	pid_t result = 0;
	GPid _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pid;
	result = (pid_t) _tmp0_;
	return result;
}


/**
     * Attach to a already running process and watch it's events. If we already watching
     * at a running process this methods fails.
     **/
static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _fso_framework_gprocess_guard_onChildWatchEvent_gchild_watch_func (GPid pid, gint status, gpointer self) {
	fso_framework_gprocess_guard_onChildWatchEvent (self, pid, status);
}


gboolean fso_framework_gprocess_guard_attach (FsoFrameworkGProcessGuard* self, pid_t pid, gchar** command, int command_length1) {
	gboolean result = FALSE;
	GPid _tmp0_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	pid_t _tmp7_;
	GPid _tmp8_;
	guint _tmp9_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pid;
	if (_tmp0_ != ((GPid) 0)) {
		pid_t _tmp1_;
		GPid _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = pid;
		_tmp2_ = self->priv->pid;
		_tmp3_ = g_strdup_printf ("Can't attach to process with id %d; already running as pid %d", (gint) _tmp1_, (gint) _tmp2_);
		_tmp4_ = _tmp3_;
		g_warning ("process.vala:122: %s", _tmp4_);
		_g_free0 (_tmp4_);
		result = FALSE;
		return result;
	}
	_tmp5_ = command;
	_tmp5__length1 = command_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup3 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	self->priv->command = (_vala_array_free (self->priv->command, self->priv->command_length1, (GDestroyNotify) g_free), NULL);
	self->priv->command = _tmp6_;
	self->priv->command_length1 = _tmp6__length1;
	self->priv->_command_size_ = self->priv->command_length1;
	_tmp7_ = pid;
	self->priv->pid = (GPid) _tmp7_;
	_tmp8_ = self->priv->pid;
	_tmp9_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp8_, _fso_framework_gprocess_guard_onChildWatchEvent_gchild_watch_func, g_object_ref (self), g_object_unref);
	self->priv->watch = _tmp9_;
	g_signal_emit_by_name ((FsoFrameworkIProcessGuard*) self, "running");
	result = TRUE;
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean fso_framework_gprocess_guard_real_launch (FsoFrameworkIProcessGuard* base, gchar** command, int command_length1) {
	FsoFrameworkGProcessGuard * self;
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GPid _tmp2_;
	GPid _tmp22_;
	guint _tmp23_ = 0U;
	GError * _inner_error_ = NULL;
	self = (FsoFrameworkGProcessGuard*) base;
	_tmp0_ = command;
	_tmp0__length1 = command_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->command = (_vala_array_free (self->priv->command, self->priv->command_length1, (GDestroyNotify) g_free), NULL);
	self->priv->command = _tmp1_;
	self->priv->command_length1 = _tmp1__length1;
	self->priv->_command_size_ = self->priv->command_length1;
	_tmp2_ = self->priv->pid;
	if (_tmp2_ != ((GPid) 0)) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GPid _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp3_ = command;
		_tmp3__length1 = command_length1;
		_tmp4_ = _tmp3_[0];
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Can't launch ", _tmp5_, "; already running as pid %d", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->pid;
		_tmp9_ = g_strdup_printf (_tmp7_, (gint) _tmp8_);
		_tmp10_ = _tmp9_;
		g_warning ("process.vala:139: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		result = FALSE;
		return result;
	}
	{
		const gchar* _tmp11_ = NULL;
		gchar** _tmp12_;
		gint _tmp12__length1;
		GPid _tmp13_ = 0;
		_tmp11_ = g_getenv ("PWD");
		_tmp12_ = command;
		_tmp12__length1 = command_length1;
		g_spawn_async (_tmp11_, _tmp12_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp13_, &_inner_error_);
		self->priv->pid = _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = command;
		_tmp14__length1 = command_length1;
		_tmp15_ = _tmp14_[0];
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = errno;
		_tmp18_ = g_strerror (_tmp17_);
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("Can't spawn ", _tmp16_, ": ", _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		g_warning ("process.vala:154: %s", _tmp21_);
		_g_free0 (_tmp21_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp22_ = self->priv->pid;
	_tmp23_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp22_, _fso_framework_gprocess_guard_onChildWatchEvent_gchild_watch_func, g_object_ref (self), g_object_unref);
	self->priv->watch = _tmp23_;
	g_signal_emit_by_name ((FsoFrameworkIProcessGuard*) self, "running");
	result = TRUE;
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gboolean fso_framework_gprocess_guard_launchWithPipes (FsoFrameworkGProcessGuard* self, gchar** command, int command_length1, gint* fdin, gint* fdout) {
	gint _vala_fdin = 0;
	gint _vala_fdout = 0;
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GPid _tmp2_;
	GPid _tmp24_;
	guint _tmp25_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = command;
	_tmp0__length1 = command_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->command = (_vala_array_free (self->priv->command, self->priv->command_length1, (GDestroyNotify) g_free), NULL);
	self->priv->command = _tmp1_;
	self->priv->command_length1 = _tmp1__length1;
	self->priv->_command_size_ = self->priv->command_length1;
	_tmp2_ = self->priv->pid;
	if (_tmp2_ != ((GPid) 0)) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GPid _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp3_ = command;
		_tmp3__length1 = command_length1;
		_tmp4_ = _tmp3_[0];
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Can't launch ", _tmp5_, "; already running as pid %d", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->pid;
		_tmp9_ = g_strdup_printf (_tmp7_, (gint) _tmp8_);
		_tmp10_ = _tmp9_;
		g_warning ("process.vala:169: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		result = FALSE;
		if (fdin) {
			*fdin = _vala_fdin;
		}
		if (fdout) {
			*fdout = _vala_fdout;
		}
		return result;
	}
	{
		const gchar* _tmp11_ = NULL;
		gchar** _tmp12_;
		gint _tmp12__length1;
		GPid _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp11_ = g_getenv ("PWD");
		_tmp12_ = command;
		_tmp12__length1 = command_length1;
		g_spawn_async_with_pipes (_tmp11_, _tmp12_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp13_, &_tmp14_, &_tmp15_, NULL, &_inner_error_);
		self->priv->pid = _tmp13_;
		_vala_fdin = _tmp14_;
		_vala_fdout = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch5_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally5;
	__catch5_g_spawn_error:
	{
		GError* e = NULL;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = command;
		_tmp16__length1 = command_length1;
		_tmp17_ = _tmp16_[0];
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Can't spawn w/ pipes ", _tmp18_, ": ", _tmp21_, ")", NULL);
		_tmp23_ = _tmp22_;
		g_warning ("process.vala:188: %s", _tmp23_);
		_g_free0 (_tmp23_);
		result = FALSE;
		_g_error_free0 (e);
		if (fdin) {
			*fdin = _vala_fdin;
		}
		if (fdout) {
			*fdout = _vala_fdout;
		}
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp24_ = self->priv->pid;
	_tmp25_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp24_, _fso_framework_gprocess_guard_onChildWatchEvent_gchild_watch_func, g_object_ref (self), g_object_unref);
	self->priv->watch = _tmp25_;
	g_signal_emit_by_name ((FsoFrameworkIProcessGuard*) self, "running");
	result = TRUE;
	if (fdin) {
		*fdin = _vala_fdin;
	}
	if (fdout) {
		*fdout = _vala_fdout;
	}
	return result;
}


static void fso_framework_gprocess_guard_real_stop (FsoFrameworkIProcessGuard* base, gint sig) {
	FsoFrameworkGProcessGuard * self;
	self = (FsoFrameworkGProcessGuard*) base;
	fso_framework_gprocess_guard_stopSendStopped (self, TRUE);
}


static void fso_framework_gprocess_guard_real_setAutoRelaunch (FsoFrameworkIProcessGuard* base, gboolean on) {
	FsoFrameworkGProcessGuard * self;
	gboolean _tmp0_;
	self = (FsoFrameworkGProcessGuard*) base;
	_tmp0_ = on;
	self->priv->relaunch = _tmp0_;
}


static gboolean fso_framework_gprocess_guard_real_sendSignal (FsoFrameworkIProcessGuard* base, gint sig) {
	FsoFrameworkGProcessGuard * self;
	gboolean result = FALSE;
	GPid _tmp0_;
	GPid _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint res;
	gint _tmp4_;
	self = (FsoFrameworkGProcessGuard*) base;
	_tmp0_ = self->priv->pid;
	if (_tmp0_ == ((GPid) 0)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->pid;
	_tmp2_ = sig;
	_tmp3_ = kill ((pid_t) _tmp1_, _tmp2_);
	res = _tmp3_;
	_tmp4_ = res;
	result = _tmp4_ == 0;
	return result;
}


static gboolean fso_framework_gprocess_guard_real_isRunning (FsoFrameworkIProcessGuard* base) {
	FsoFrameworkGProcessGuard * self;
	gboolean result = FALSE;
	GPid _tmp0_;
	self = (FsoFrameworkGProcessGuard*) base;
	_tmp0_ = self->priv->pid;
	result = _tmp0_ != ((GPid) 0);
	return result;
}


static void fso_framework_gprocess_guard_stopSendStopped (FsoFrameworkGProcessGuard* self, gboolean send) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = send;
	_fso_framework_gprocess_guard_stop (self, _tmp0_, NULL, NULL);
}


static void fso_framework_gprocess_guard_cleanupResources (FsoFrameworkGProcessGuard* self) {
	guint _tmp0_;
	GPid _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->watch;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->watch;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = self->priv->pid;
	g_spawn_close_pid (_tmp2_);
	self->priv->pid = (GPid) 0;
	g_signal_emit_by_name ((FsoFrameworkIProcessGuard*) self, "stopped");
}


static void fso_framework_gprocess_guard_onChildWatchEvent (FsoFrameworkGProcessGuard* self, GPid pid, gint status) {
	GPid _tmp0_;
	GPid _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pid;
	_tmp1_ = pid;
	if (_tmp0_ != _tmp1_) {
		g_critical ("process.vala:247: D'OH!");
		return;
	}
	pid = (GPid) 0;
	fso_framework_gprocess_guard_cleanupResources (self);
	_tmp2_ = self->priv->relaunch;
	if (_tmp2_) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->command;
		_tmp3__length1 = self->priv->command_length1;
		_tmp4_ = fso_framework_iprocess_guard_launch ((FsoFrameworkIProcessGuard*) self, _tmp3_, _tmp3__length1);
		if (!_tmp4_) {
			gchar** _tmp5_;
			gint _tmp5__length1;
			const gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp5_ = self->priv->command;
			_tmp5__length1 = self->priv->command_length1;
			_tmp6_ = _tmp5_[0];
			_tmp7_ = string_to_string (_tmp6_);
			_tmp8_ = g_strconcat ("Could not relaunch ", _tmp7_, "; disabling.", NULL);
			_tmp9_ = _tmp8_;
			g_warning ("process.vala:263: %s", _tmp9_);
			_g_free0 (_tmp9_);
			self->priv->relaunch = FALSE;
		}
	}
}


static void _fso_framework_gprocess_guard_stop_data_free (gpointer _data) {
	FsoFrameworkGprocessGuardStopData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoFrameworkGprocessGuardStopData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _fso_framework_gprocess_guard_stop (FsoFrameworkGProcessGuard* self, gboolean send, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoFrameworkGprocessGuardStopData* _data_;
	FsoFrameworkGProcessGuard* _tmp0_;
	gboolean _tmp1_;
	_data_ = g_slice_new0 (FsoFrameworkGprocessGuardStopData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _fso_framework_gprocess_guard_stop);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _fso_framework_gprocess_guard_stop_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = send;
	_data_->send = _tmp1_;
	_fso_framework_gprocess_guard_stop_co (_data_);
}


static void _fso_framework_gprocess_guard_stop_finish (FsoFrameworkGProcessGuard* self, GAsyncResult* _res_) {
	FsoFrameworkGprocessGuardStopData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean __fso_framework_gprocess_guard_stop_co_gsource_func (gpointer self) {
	gboolean result;
	result = _fso_framework_gprocess_guard_stop_co (self);
	return result;
}


static gboolean _fso_framework_gprocess_guard_stop_co (FsoFrameworkGprocessGuardStopData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->pid;
	if (((pid_t) _data_->_tmp0_) == ((pid_t) 0)) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->pid;
	kill ((pid_t) _data_->_tmp1_, SIGTERM);
	_data_->done = FALSE;
	_data_->_tmp2_ = g_timer_new ();
	_data_->timer = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->timer;
	g_timer_start (_data_->_tmp3_);
	while (TRUE) {
		_data_->_tmp5_ = _data_->done;
		if (!_data_->_tmp5_) {
			_data_->_tmp6_ = _data_->self->priv->pid;
			_data_->_tmp4_ = _data_->_tmp6_ != ((GPid) 0);
		} else {
			_data_->_tmp4_ = FALSE;
		}
		_data_->_tmp7_ = _data_->_tmp4_;
		if (!_data_->_tmp7_) {
			break;
		}
		_data_->_tmp8_ = _data_->self->priv->pid;
		_data_->_tmp9_ = 0;
		_data_->_tmp9_ = waitpid ((pid_t) _data_->_tmp8_, NULL, WNOHANG);
		_data_->pid_result = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->pid_result;
		if (_data_->_tmp10_ < ((pid_t) 0)) {
			_data_->done = TRUE;
		} else {
			_data_->_tmp11_ = _data_->pid_result;
			if (_data_->_tmp11_ == ((pid_t) 0)) {
				_data_->_tmp12_ = _data_->timer;
				_data_->_tmp13_ = 0.0;
				_data_->_tmp13_ = g_timer_elapsed (_data_->_tmp12_, NULL);
				if (_data_->_tmp13_ >= ((gdouble) FSO_FRAMEWORK_GPROCESS_GUARD_KILL_SLEEP_TIMEOUT)) {
					_data_->done = TRUE;
				} else {
					g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __fso_framework_gprocess_guard_stop_co_gsource_func, _data_, NULL);
					_data_->_state_ = 1;
					return FALSE;
					_state_1:
					;
				}
			} else {
				_data_->done = TRUE;
				_data_->_tmp14_ = _data_->self->priv->pid;
				g_spawn_close_pid (_data_->_tmp14_);
				_data_->self->priv->pid = (GPid) 0;
			}
		}
	}
	_data_->_tmp15_ = _data_->self->priv->pid;
	if (_data_->_tmp15_ != ((GPid) 0)) {
		_data_->_tmp16_ = _data_->self->priv->pid;
		g_warning ("process.vala:330: Process %d ignored SIGTERM, sending SIGKILL", (gint) _data_->_tmp16_);
		_data_->_tmp17_ = _data_->self->priv->watch;
		if (_data_->_tmp17_ > ((guint) 0)) {
			_data_->_tmp18_ = _data_->self->priv->watch;
			g_source_remove (_data_->_tmp18_);
			_data_->self->priv->watch = (guint) 0;
		}
		_data_->_tmp19_ = _data_->self->priv->pid;
		kill ((pid_t) _data_->_tmp19_, SIGKILL);
		g_usleep ((gulong) 1000);
		_data_->self->priv->pid = (GPid) 0;
	}
	_data_->_tmp20_ = _data_->send;
	if (_data_->_tmp20_) {
		g_signal_emit_by_name ((FsoFrameworkIProcessGuard*) _data_->self, "stopped");
	}
	_g_timer_destroy0 (_data_->timer);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_framework_gprocess_guard_syncStop (FsoFrameworkGProcessGuard* self) {
	guint _tmp0_;
	GPid _tmp2_;
	gboolean done;
	GTimer* _tmp3_;
	GTimer* timer;
	GTimer* _tmp4_;
	GPid _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->watch;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->watch;
		g_source_remove (_tmp1_);
		self->priv->watch = (guint) 0;
	}
	_tmp2_ = self->priv->pid;
	kill ((pid_t) _tmp2_, SIGTERM);
	done = FALSE;
	_tmp3_ = g_timer_new ();
	timer = _tmp3_;
	_tmp4_ = timer;
	g_timer_start (_tmp4_);
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp8_;
		GPid _tmp9_;
		pid_t _tmp10_ = 0;
		pid_t pid_result;
		pid_t _tmp11_;
		_tmp6_ = done;
		if (!_tmp6_) {
			GPid _tmp7_;
			_tmp7_ = self->priv->pid;
			_tmp5_ = _tmp7_ != ((GPid) 0);
		} else {
			_tmp5_ = FALSE;
		}
		_tmp8_ = _tmp5_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = self->priv->pid;
		_tmp10_ = waitpid ((pid_t) _tmp9_, NULL, WNOHANG);
		pid_result = _tmp10_;
		_tmp11_ = pid_result;
		if (_tmp11_ < ((pid_t) 0)) {
			done = TRUE;
		} else {
			pid_t _tmp12_;
			_tmp12_ = pid_result;
			if (_tmp12_ == ((pid_t) 0)) {
				GTimer* _tmp13_;
				gdouble _tmp14_ = 0.0;
				_tmp13_ = timer;
				_tmp14_ = g_timer_elapsed (_tmp13_, NULL);
				if (_tmp14_ >= ((gdouble) FSO_FRAMEWORK_GPROCESS_GUARD_KILL_SLEEP_TIMEOUT)) {
					done = TRUE;
				} else {
					g_usleep ((gulong) FSO_FRAMEWORK_GPROCESS_GUARD_KILL_SLEEP_INTERVAL);
				}
			} else {
				GPid _tmp15_;
				done = TRUE;
				_tmp15_ = self->priv->pid;
				g_spawn_close_pid (_tmp15_);
				self->priv->pid = (GPid) 0;
			}
		}
	}
	_tmp16_ = self->priv->pid;
	if (_tmp16_ != ((GPid) 0)) {
		GPid _tmp17_;
		guint _tmp18_;
		GPid _tmp20_;
		_tmp17_ = self->priv->pid;
		g_warning ("process.vala:410: Process %d ignored SIGTERM, sending SIGKILL", (gint) _tmp17_);
		_tmp18_ = self->priv->watch;
		if (_tmp18_ > ((guint) 0)) {
			guint _tmp19_;
			_tmp19_ = self->priv->watch;
			g_source_remove (_tmp19_);
		}
		_tmp20_ = self->priv->pid;
		kill ((pid_t) _tmp20_, SIGKILL);
		g_usleep ((gulong) 1000);
		self->priv->pid = (GPid) 0;
	}
	_g_timer_destroy0 (timer);
}


FsoFrameworkGProcessGuard* fso_framework_gprocess_guard_construct (GType object_type) {
	FsoFrameworkGProcessGuard * self = NULL;
	self = (FsoFrameworkGProcessGuard*) g_object_new (object_type, NULL);
	return self;
}


FsoFrameworkGProcessGuard* fso_framework_gprocess_guard_new (void) {
	return fso_framework_gprocess_guard_construct (FSO_FRAMEWORK_TYPE_GPROCESS_GUARD);
}


static void fso_framework_gprocess_guard_class_init (FsoFrameworkGProcessGuardClass * klass) {
	fso_framework_gprocess_guard_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkGProcessGuardPrivate));
	G_OBJECT_CLASS (klass)->finalize = fso_framework_gprocess_guard_finalize;
}


static void fso_framework_gprocess_guard_fso_framework_iprocess_guard_interface_init (FsoFrameworkIProcessGuardIface * iface) {
	fso_framework_gprocess_guard_fso_framework_iprocess_guard_parent_iface = g_type_interface_peek_parent (iface);
	iface->launch = (gboolean (*)(FsoFrameworkIProcessGuard*, gchar**, int)) fso_framework_gprocess_guard_real_launch;
	iface->stop = (void (*)(FsoFrameworkIProcessGuard*, gint)) fso_framework_gprocess_guard_real_stop;
	iface->setAutoRelaunch = (void (*)(FsoFrameworkIProcessGuard*, gboolean)) fso_framework_gprocess_guard_real_setAutoRelaunch;
	iface->sendSignal = (gboolean (*)(FsoFrameworkIProcessGuard*, gint)) fso_framework_gprocess_guard_real_sendSignal;
	iface->isRunning = (gboolean (*)(FsoFrameworkIProcessGuard*)) fso_framework_gprocess_guard_real_isRunning;
}


static void fso_framework_gprocess_guard_instance_init (FsoFrameworkGProcessGuard * self) {
	self->priv = FSO_FRAMEWORK_GPROCESS_GUARD_GET_PRIVATE (self);
}


static void fso_framework_gprocess_guard_finalize (GObject* obj) {
	FsoFrameworkGProcessGuard * self;
	GPid _tmp0_;
	self = FSO_FRAMEWORK_GPROCESS_GUARD (obj);
	_tmp0_ = self->priv->pid;
	if (_tmp0_ != ((GPid) 0)) {
		self->priv->relaunch = FALSE;
		fso_framework_gprocess_guard_syncStop (self);
	}
	self->priv->command = (_vala_array_free (self->priv->command, self->priv->command_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (fso_framework_gprocess_guard_parent_class)->finalize (obj);
}


/**
 * @class FsoFramework.GProcessGuard
 **/
GType fso_framework_gprocess_guard_get_type (void) {
	static volatile gsize fso_framework_gprocess_guard_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_gprocess_guard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkGProcessGuardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_gprocess_guard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkGProcessGuard), 0, (GInstanceInitFunc) fso_framework_gprocess_guard_instance_init, NULL };
		static const GInterfaceInfo fso_framework_iprocess_guard_info = { (GInterfaceInitFunc) fso_framework_gprocess_guard_fso_framework_iprocess_guard_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType fso_framework_gprocess_guard_type_id;
		fso_framework_gprocess_guard_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkGProcessGuard", &g_define_type_info, 0);
		g_type_add_interface_static (fso_framework_gprocess_guard_type_id, FSO_FRAMEWORK_TYPE_IPROCESS_GUARD, &fso_framework_iprocess_guard_info);
		g_once_init_leave (&fso_framework_gprocess_guard_type_id__volatile, fso_framework_gprocess_guard_type_id);
	}
	return fso_framework_gprocess_guard_type_id__volatile;
}


void async_process_set_stdout_watch (AsyncProcess* self, GIOFunc watch, void* watch_target, GIOCondition cond, GIOFlags flags) {
	GIOFunc _tmp0_;
	void* _tmp0__target;
	GIOCondition _tmp1_;
	GIOFlags _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = watch;
	_tmp0__target = watch_target;
	(self->priv->stdout_watch_target_destroy_notify == NULL) ? NULL : (self->priv->stdout_watch_target_destroy_notify (self->priv->stdout_watch_target), NULL);
	self->priv->stdout_watch = NULL;
	self->priv->stdout_watch_target = NULL;
	self->priv->stdout_watch_target_destroy_notify = NULL;
	self->priv->stdout_watch = _tmp0_;
	self->priv->stdout_watch_target = _tmp0__target;
	self->priv->stdout_watch_target_destroy_notify = NULL;
	_tmp1_ = cond;
	self->priv->stdout_condition = _tmp1_;
	_tmp2_ = flags;
	self->priv->stdout_flags = _tmp2_;
}


void async_process_set_stderr_watch (AsyncProcess* self, GIOFunc watch, void* watch_target, GIOCondition cond, GIOFlags flags) {
	GIOFunc _tmp0_;
	void* _tmp0__target;
	GIOCondition _tmp1_;
	GIOFlags _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = watch;
	_tmp0__target = watch_target;
	(self->priv->stderr_watch_target_destroy_notify == NULL) ? NULL : (self->priv->stderr_watch_target_destroy_notify (self->priv->stderr_watch_target), NULL);
	self->priv->stderr_watch = NULL;
	self->priv->stderr_watch_target = NULL;
	self->priv->stderr_watch_target_destroy_notify = NULL;
	self->priv->stderr_watch = _tmp0_;
	self->priv->stderr_watch_target = _tmp0__target;
	self->priv->stderr_watch_target_destroy_notify = NULL;
	_tmp1_ = cond;
	self->priv->stderr_condition = _tmp1_;
	_tmp2_ = flags;
	self->priv->stderr_flags = _tmp2_;
}


static void async_process_launch_data_free (gpointer _data) {
	AsyncProcessLaunchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancel);
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (AsyncProcessLaunchData, _data_);
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void async_process_launch (AsyncProcess* self, GCancellable* cancel, gchar** argv, int argv_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AsyncProcessLaunchData* _data_;
	AsyncProcess* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	_data_ = g_slice_new0 (AsyncProcessLaunchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, async_process_launch);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, async_process_launch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancel;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancel = _tmp2_;
	_tmp3_ = argv;
	_tmp3__length1 = argv_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup6 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_data_->argv = _tmp4_;
	_data_->argv_length1 = _tmp4__length1;
	async_process_launch_co (_data_);
}


gint async_process_launch_finish (AsyncProcess* self, GAsyncResult* _res_, GError** error) {
	gint result;
	AsyncProcessLaunchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _async_process_onExit_gchild_watch_func (GPid pid, gint status, gpointer self) {
	async_process_onExit (self, pid, status);
}


static void _async_process_onCancel_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	async_process_onCancel (self);
}


static gboolean _async_process_launch_co_gsource_func (gpointer self) {
	gboolean result;
	result = async_process_launch_co (self);
	return result;
}


static gboolean async_process_launch_co (AsyncProcessLaunchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->cancel;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->cancel;
		_data_->_tmp3_ = FALSE;
		_data_->_tmp3_ = g_cancellable_is_cancelled (_data_->_tmp2_);
		_data_->_tmp0_ = _data_->_tmp3_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp0_;
	if (_data_->_tmp4_) {
		_data_->result = -1;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->argv;
	_data_->_tmp5__length1 = _data_->argv_length1;
	_data_->_tmp6_ = (_data_->_tmp5_ != NULL) ? _vala_array_dup7 (_data_->_tmp5_, _data_->_tmp5__length1) : ((gpointer) _data_->_tmp5_);
	_data_->_tmp6__length1 = _data_->_tmp5__length1;
	_data_->self->priv->argv = (_vala_array_free (_data_->self->priv->argv, _data_->self->priv->argv_length1, (GDestroyNotify) g_free), NULL);
	_data_->self->priv->argv = _data_->_tmp6_;
	_data_->self->priv->argv_length1 = _data_->_tmp6__length1;
	_data_->self->priv->_argv_size_ = _data_->self->priv->argv_length1;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_getenv ("PWD");
	_data_->_tmp8_ = _data_->argv;
	_data_->_tmp8__length1 = _data_->argv_length1;
	_data_->_tmp9_ = 0;
	_data_->_tmp10_ = 0;
	_data_->_tmp11_ = 0;
	_data_->_tmp12_ = 0;
	g_spawn_async_with_pipes (_data_->_tmp7_, _data_->_tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp9_, &_data_->_tmp10_, &_data_->_tmp11_, &_data_->_tmp12_, &_data_->_inner_error_);
	_data_->self->priv->pid = _data_->_tmp9_;
	_data_->self->priv->_std_in = _data_->_tmp10_;
	_data_->self->priv->std_out = _data_->_tmp11_;
	_data_->self->priv->std_err = _data_->_tmp12_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == G_SPAWN_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp13_ = _data_->self->priv->stdout_watch;
	_data_->_tmp13__target = _data_->self->priv->stdout_watch_target;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = _data_->self->priv->std_out;
		_data_->_tmp15_ = g_io_channel_unix_new (_data_->_tmp14_);
		_g_io_channel_unref0 (_data_->self->priv->out_channel);
		_data_->self->priv->out_channel = _data_->_tmp15_;
		{
			_data_->_tmp16_ = _data_->self->priv->out_channel;
			_data_->_tmp17_ = _data_->self->priv->stdout_flags;
			g_io_channel_set_flags (_data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch6_g_io_channel_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally6;
		__catch6_g_io_channel_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp18_ = _data_->e1;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = string_to_string (_data_->_tmp19_);
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_strconcat ("Could not set flags for stdout: ", _data_->_tmp20_, NULL);
			_data_->_tmp22_ = _data_->_tmp21_;
			g_warning ("process.vala:513: %s", _data_->_tmp22_);
			_g_free0 (_data_->_tmp22_);
			_g_error_free0 (_data_->e1);
		}
		__finally6:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_SPAWN_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp23_ = _data_->self->priv->out_channel;
		_data_->_tmp24_ = _data_->self->priv->stdout_condition;
		_data_->_tmp25_ = _data_->self->priv->stdout_watch;
		_data_->_tmp25__target = _data_->self->priv->stdout_watch_target;
		g_io_add_watch (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->_tmp25__target);
	}
	_data_->_tmp26_ = _data_->self->priv->stderr_watch;
	_data_->_tmp26__target = _data_->self->priv->stderr_watch_target;
	if (_data_->_tmp26_ != NULL) {
		_data_->_tmp27_ = _data_->self->priv->std_out;
		_data_->_tmp28_ = g_io_channel_unix_new (_data_->_tmp27_);
		_g_io_channel_unref0 (_data_->self->priv->err_channel);
		_data_->self->priv->err_channel = _data_->_tmp28_;
		{
			_data_->_tmp29_ = _data_->self->priv->err_channel;
			_data_->_tmp30_ = _data_->self->priv->stdout_flags;
			g_io_channel_set_flags (_data_->_tmp29_, _data_->_tmp30_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch7_g_io_channel_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally7;
		__catch7_g_io_channel_error:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp31_ = _data_->e2;
			_data_->_tmp32_ = _data_->_tmp31_->message;
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = string_to_string (_data_->_tmp32_);
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = g_strconcat ("Could not set flags for stderr: ", _data_->_tmp33_, NULL);
			_data_->_tmp35_ = _data_->_tmp34_;
			g_warning ("process.vala:527: %s", _data_->_tmp35_);
			_g_free0 (_data_->_tmp35_);
			_g_error_free0 (_data_->e2);
		}
		__finally7:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_SPAWN_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp36_ = _data_->self->priv->err_channel;
		_data_->_tmp37_ = _data_->self->priv->stdout_condition;
		_data_->_tmp38_ = _data_->self->priv->stdout_watch;
		_data_->_tmp38__target = _data_->self->priv->stdout_watch_target;
		g_io_add_watch (_data_->_tmp36_, _data_->_tmp37_, _data_->_tmp38_, _data_->_tmp38__target);
	}
	_data_->_tmp39_ = _data_->self->priv->pid;
	_data_->_tmp40_ = 0U;
	_data_->_tmp40_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _data_->_tmp39_, _async_process_onExit_gchild_watch_func, g_object_ref (_data_->self), g_object_unref);
	_data_->self->priv->child = _data_->_tmp40_;
	_data_->_tmp41_ = _data_->cancel;
	if (_data_->_tmp41_ != NULL) {
		_data_->_tmp42_ = _data_->cancel;
		g_signal_connect_object (_data_->_tmp42_, "cancelled", (GCallback) _async_process_onCancel_g_cancellable_cancelled, _data_->self, 0);
	}
	(_data_->self->priv->callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->callback_target_destroy_notify (_data_->self->priv->callback_target), NULL);
	_data_->self->priv->callback = NULL;
	_data_->self->priv->callback_target = NULL;
	_data_->self->priv->callback_target_destroy_notify = NULL;
	_data_->self->priv->callback = _async_process_launch_co_gsource_func;
	_data_->self->priv->callback_target = _data_;
	_data_->self->priv->callback_target_destroy_notify = NULL;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp43_ = _data_->self->priv->status;
	_data_->result = _data_->_tmp43_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void async_process_onCancel (AsyncProcess* self) {
	GPid _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pid;
	if (((pid_t) _tmp0_) == ((pid_t) 0)) {
		return;
	}
	async_process_onCancelAsync (self, NULL, NULL);
}


static void async_process_onCancelAsync_data_free (gpointer _data) {
	async_process_onCancelAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (async_process_onCancelAsyncData, _data_);
}


static void async_process_onCancelAsync (AsyncProcess* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	async_process_onCancelAsyncData* _data_;
	AsyncProcess* _tmp0_;
	_data_ = g_slice_new0 (async_process_onCancelAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, async_process_onCancelAsync);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, async_process_onCancelAsync_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	async_process_onCancelAsync_co (_data_);
}


static void async_process_onCancelAsync_finish (AsyncProcess* self, GAsyncResult* _res_) {
	async_process_onCancelAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void async_process_onCancelAsync_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	async_process_onCancelAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	async_process_onCancelAsync_co (_data_);
}


static gboolean async_process_onCancelAsync_co (async_process_onCancelAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->i = 0;
		{
			_data_->_tmp0_ = TRUE;
			while (TRUE) {
				_data_->_tmp1_ = _data_->_tmp0_;
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp0_ = FALSE;
				_data_->_tmp3_ = _data_->i;
				if (!(_data_->_tmp3_ < ASYNC_PROCESS_NUM_FRIENDLY_KILLS)) {
					break;
				}
				_data_->_tmp4_ = _data_->self->priv->pid;
				if (_data_->_tmp4_ == ((GPid) 0)) {
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp5_ = _data_->self->priv->pid;
				kill ((pid_t) _data_->_tmp5_, SIGTERM);
				_data_->_state_ = 1;
				fso_framework_async_sleep_async (1000, NULL, async_process_onCancelAsync_ready, _data_);
				return FALSE;
				_state_1:
				fso_framework_async_sleep_finish (_data_->_res_);
			}
		}
	}
	_data_->_tmp6_ = _data_->self->priv->pid;
	if (_data_->_tmp6_ != ((GPid) 0)) {
		_data_->_tmp7_ = _data_->self->priv->pid;
		kill ((pid_t) _data_->_tmp7_, SIGKILL);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void async_process_onExit (AsyncProcess* self, GPid p, gint status) {
	GSourceFunc _tmp0_;
	void* _tmp0__target;
	gint _tmp1_;
	GSourceFunc _tmp2_;
	void* _tmp2__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->callback;
	_tmp0__target = self->priv->callback_target;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = status;
	self->priv->status = _tmp1_;
	self->priv->pid = (GPid) 0;
	_tmp2_ = self->priv->callback;
	_tmp2__target = self->priv->callback_target;
	_tmp2_ (_tmp2__target);
}


AsyncProcess* async_process_construct (GType object_type) {
	AsyncProcess * self = NULL;
	self = (AsyncProcess*) g_object_new (object_type, NULL);
	return self;
}


AsyncProcess* async_process_new (void) {
	return async_process_construct (TYPE_ASYNC_PROCESS);
}


gint async_process_get_std_in (AsyncProcess* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_std_in;
	result = _tmp0_;
	return result;
}


const gchar* async_process_get_cmd_line (AsyncProcess* self) {
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cmd_line;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gint _tmp1__length1;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->priv->argv;
		_tmp1__length1 = self->priv->argv_length1;
		_tmp2_ = g_strjoinv ("\" \"", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("\"", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "\"", NULL);
		_g_free0 (self->priv->_cmd_line);
		self->priv->_cmd_line = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
	_tmp7_ = self->priv->_cmd_line;
	result = _tmp7_;
	return result;
}


static void async_process_class_init (AsyncProcessClass * klass) {
	async_process_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AsyncProcessPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_async_process_get_property;
	G_OBJECT_CLASS (klass)->finalize = async_process_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASYNC_PROCESS_STD_IN, g_param_spec_int ("std-in", "std-in", "std-in", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASYNC_PROCESS_CMD_LINE, g_param_spec_string ("cmd-line", "cmd-line", "cmd-line", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void async_process_instance_init (AsyncProcess * self) {
	self->priv = ASYNC_PROCESS_GET_PRIVATE (self);
	self->priv->_cmd_line = NULL;
	self->priv->pid = (GPid) 0;
	self->priv->_std_in = -1;
	self->priv->status = 0;
}


static void async_process_finalize (GObject* obj) {
	AsyncProcess * self;
	guint _tmp0_;
	self = ASYNC_PROCESS (obj);
	_tmp0_ = self->priv->child;
	g_source_remove (_tmp0_);
	(self->priv->stdout_watch_target_destroy_notify == NULL) ? NULL : (self->priv->stdout_watch_target_destroy_notify (self->priv->stdout_watch_target), NULL);
	self->priv->stdout_watch = NULL;
	self->priv->stdout_watch_target = NULL;
	self->priv->stdout_watch_target_destroy_notify = NULL;
	(self->priv->stderr_watch_target_destroy_notify == NULL) ? NULL : (self->priv->stderr_watch_target_destroy_notify (self->priv->stderr_watch_target), NULL);
	self->priv->stderr_watch = NULL;
	self->priv->stderr_watch_target = NULL;
	self->priv->stderr_watch_target_destroy_notify = NULL;
	_g_free0 (self->priv->_cmd_line);
	self->priv->argv = (_vala_array_free (self->priv->argv, self->priv->argv_length1, (GDestroyNotify) g_free), NULL);
	(self->priv->callback_target_destroy_notify == NULL) ? NULL : (self->priv->callback_target_destroy_notify (self->priv->callback_target), NULL);
	self->priv->callback = NULL;
	self->priv->callback_target = NULL;
	self->priv->callback_target_destroy_notify = NULL;
	_g_io_channel_unref0 (self->priv->err_channel);
	_g_io_channel_unref0 (self->priv->out_channel);
	G_OBJECT_CLASS (async_process_parent_class)->finalize (obj);
}


GType async_process_get_type (void) {
	static volatile gsize async_process_type_id__volatile = 0;
	if (g_once_init_enter (&async_process_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AsyncProcessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) async_process_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AsyncProcess), 0, (GInstanceInitFunc) async_process_instance_init, NULL };
		GType async_process_type_id;
		async_process_type_id = g_type_register_static (G_TYPE_OBJECT, "AsyncProcess", &g_define_type_info, 0);
		g_once_init_leave (&async_process_type_id__volatile, async_process_type_id);
	}
	return async_process_type_id__volatile;
}


static void _vala_async_process_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AsyncProcess * self;
	self = ASYNC_PROCESS (object);
	switch (property_id) {
		case ASYNC_PROCESS_STD_IN:
		g_value_set_int (value, async_process_get_std_in (self));
		break;
		case ASYNC_PROCESS_CMD_LINE:
		g_value_set_string (value, async_process_get_cmd_line (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



