/**
 * @file libgalago/galago-utils-priv.h Private utility functions
 *
 * @Copyright (C) 2005 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_UTILS_PRIV_H_
#define _GALAGO_UTILS_PRIV_H_

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdlib.h>
#include <libgalago/galago-dbus-compat.h>

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************/
/** @name Misc. macros                                                    */
/**************************************************************************/
/*@{*/

/* Thanks glib */
#if !defined(GALAGO_VA_COPY)
#  if defined(__GNUC__) && defined(__PPC__) && (defined(_CALL_SYSV) || defined(_WIN32))
#    define GALAGO_VA_COPY(ap1, ap2)   (*(ap1) = *(ap2))
#  elif defined (GALAGO_VA_COPY_AS_ARRAY)
#    define GALAGO_VA_COPY(ap1, ap2)   g_memmove((ap1), (ap2), sizeof(va_list))
#  else /* va_list is a pointer */
#    define GALAGO_VA_COPY(ap1, ap2)   ((ap1) = (ap2))
#  endif /* va_list is a pointer */
#endif /* !GALAGO_VA_COPY */


#define DEPRECATE_OLD_GET_CLASS(oldname, newname) \
GalagoObjectClass * \
oldname##_get_class(void) \
{ \
	galago_log_warning("%s_get_class() is deprecated. Please recompile " \
					   "your application to fix this error.\n", #oldname); \
	return newname##_get_class(); \
}

/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _GALAGO_UTILS_H_ */
