/**
 * @file libgalago/galago-utils.h Utility functions
 *
 * @Copyright (C) 2004-2005 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_UTILS_H_
#define _GALAGO_UTILS_H_

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************/
/** @name String functions                                                */
/**************************************************************************/
/*{*/

/**
 * Converts a string to lowercase.
 *
 * @param str The string.
 *
 * @return The new string.
 */
char *galago_str_lower(const char *str);

/**
 * Converts a string to uppercase.
 *
 * @param str The string.
 *
 * @return The new string.
 */
char *galago_str_upper(const char *str);

/*@}*/

/**************************************************************************/
/** @name Memory allocation functions                                     */
/**************************************************************************/
/*@{*/

/**
 * Allocates a block of memory and sets the bytes to 0.
 *
 * @param bytes The number of bytes to allocate.
 *
 * @return The new block of memory.
 */
void *galago_malloc0(size_t bytes);

/**
 * Duplicates a block of memory of the specified size.
 *
 * @param ptr  The memory to duplicate.
 * @param size The size of the block.
 *
 * @return The new duplicated block of memory.
 */
void *galago_memdup(const void *ptr, size_t size);

#define galago_new(struct_type, n_structs) \
	((struct_type *)malloc(sizeof(struct_type) * (n_structs)))

#define galago_new0(struct_type, n_structs) \
	((struct_type *)galago_malloc0(sizeof(struct_type) * (n_structs)))

/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _GALAGO_UTILS_H_ */
