/**
 * @file property-test.c A simple test for properties
 *
 * @Copyright (C) 2004 Trent Lloyd  <lathiat@bur.st>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <glib.h>
#include <dbus/dbus-glib.h>
#include <stdio.h>
#include <string.h>

int
main(int argc, char *argv[])
{
	GalagoService *service;
	GalagoAccount *account;
	GalagoPerson *person;
	GalagoPresence *presence;
	GalagoStatus *status;

	if (!galago_init("property-test-feed", TRUE))
		return 1;

	/* Setup our test service */
	service  = galago_service_new("lathiat", "Lathiats Godly Program",
								  TRUE, 0);
	person   = galago_person_new("dizzy", TRUE);
	account  = galago_account_new(service, person, "lathiat");
	presence = galago_presence_new(account);

	status = galago_status_new(GALAGO_STATUS_AVAILABLE, "harass",
							   "Taking harassments", TRUE);

	galago_presence_add_status(presence, status);

	galago_person_set_property_string(person, "email", "lathiat@bur.st");
	galago_person_set_property_string(person, "x-godly", "false");

	printf("Properties: (email=lathiat@bur.st)=%s, (x-godly=false)=%s\n",
			galago_person_get_property_string(person, "email"),
			galago_person_get_property_string(person, "x-godly"));

	printf("Removing godly\n");

	galago_person_remove_property(person, "x-godly");

	printf("Properties: (email=lathiat@bur.st)=%s, (x-godly=NULL)=%s\n",
			galago_person_get_property_string(person, "email"),
			galago_person_get_property_string(person, "x-godly"));

	printf("Changing email\n");

	galago_person_set_property_string(person, "email", "lathiat@sixlabs.org");

	printf("Properties: (email=lathiat@sixlabs.org)=%s, (x-godly=NULL)=%s\n",
			galago_person_get_property_string(person, "email"),
			galago_person_get_property_string(person, "x-godly"));

	printf("done.\n");

	return 0;
}
