/*
 * debug.c: log (or not) messages using syslog
 * Copyright (C) 2001 Ludovic Rousseau <ludovic.rousseau@free.fr>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59 
 * Temple Place, Suite 330, Boston, MA  02111-1307 USA
 * 
 */

/*
 * $Id
 */

#include <stdarg.h>
#include <stdio.h>
#include <syslog.h>
#include <string.h>

#include "debug.h"

#define DEBUG_BUF_SIZE (256*3+30)

#ifdef DEBUG
void DEBUG_MSG(char *fmt, ...)
{
	char debug_buf[DEBUG_BUF_SIZE];
	va_list argptr;

	va_start(argptr, fmt);
	vsnprintf(debug_buf, DEBUG_BUF_SIZE, fmt, argptr);
	va_end(argptr);

	syslog(LOG_DEBUG, "%s", debug_buf);
} /* DEBUG_MSG */

void DEBUG_XXD(char *msg, unsigned char *buffer, int len)
{
	char debug_buf[DEBUG_BUF_SIZE];
	int i;
	char *c, *debug_buf_end;

	c = debug_buf;
	debug_buf_end = debug_buf + DEBUG_BUF_SIZE - 5;

	strncpy(c, msg, DEBUG_BUF_SIZE);
	c += strlen(c);

	for (i = 0; (i < len) && (c < debug_buf_end); ++i)
	{
		sprintf(c, "%02X ", buffer[i]);
		c += strlen(c);
	}

	syslog(LOG_DEBUG, "%s", debug_buf);
}

#ifdef OLD_CODE
void DEBUG_XXD(char *buffer, int size)
{
	char ligne[80];
	int col, lig = 0;
	unsigned char c;
	long address = 0;

	ligne[59+16] = '\0';

	while (size>0)
	{
		sprintf(ligne, "%08lX  ", address);

		for (col=0; col<16; col++)
		{
			c = *buffer++;	/* octet courant */

			sprintf(&ligne[col*3+10], "%02X ", c);	/* Hexa */
			if (c < 32)
				c = '.';
			ligne[col+59] = c;	/* ASCII */
		}
		ligne[58] = ' ';

		lig += 16;
		address += 16;
		size -= 16;

		if (size < 0)
		{
			for (col=16+size; col<16; col++)
			{
				strcpy(&ligne[col*3+10], "   ");
				ligne[col+59] = ' ';
			}
			ligne[58] = ' ';
		}
		printf("%s\n", ligne);
	}
} /* DEBUG_XXD */
#endif

#endif


