#line 59 "../noweb/o_circle_basic.nw"
/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/o_circle_basic.nw"
/* DO NOT read or edit this file ! Use ../noweb/o_circle_basic.nw instead */

#line 81 "../noweb/o_circle_basic.nw"
#include <config.h>
#include <stdio.h>
#include <math.h>

#include <gtk/gtk.h>
#include <guile/gh.h>

#ifdef HAS_LIBGDGEDA
#include <gdgeda/gd.h>
#endif

#include "defines.h"
#include "struct.h"
#include "globals.h"
#include "o_types.h"

#include "colors.h"
#include "funcs.h"

#include "../include/prototype.h"


#line 111 "../noweb/o_circle_basic.nw"
int dist(int x1, int y1, int x2, int y2)
{
  int dx1, dy1;
  int dx2, dy2;
  int ret;

  dx1 = x1;
  dy1 = y1;
  dx2 = x2;
  dy2 = y2;

  ret = sqrt(pow(dx1 - dx2, 2) + pow(dy1 - dy2, 2));
  return (ret);
}


#line 147 "../noweb/o_circle_basic.nw"
OBJECT *o_circle_add(TOPLEVEL * w_current, OBJECT * object_list,
		     char type, int color, int x, int y, int radius)
{
  OBJECT *new_node;


#line 169 "../noweb/o_circle_basic.nw"
/* create the object */
  new_node = s_basic_init_object("circle");
  new_node->type = type;
  new_node->color = color;

  new_node->circle = (CIRCLE *) malloc(sizeof(CIRCLE));


#line 156 "../noweb/o_circle_basic.nw"

#line 180 "../noweb/o_circle_basic.nw"
/* describe the circle with its center and radius */
  new_node->circle->center_x = x;
  new_node->circle->center_y = y;
  new_node->circle->radius = radius;

/* line type and filling initialized to default */
  o_set_line_options(w_current, new_node, END_NONE, TYPE_SOLID, 0, -1, -1);
  o_set_fill_options(w_current, new_node,
		     FILLING_HOLLOW, -1, -1, -1, -1, -1);

/* TODO: questionable cast */
  new_node->draw_func = (void *) circle_draw_func;
/* TODO: questionable cast */
  new_node->sel_func = (void *) select_func;


#line 158 "../noweb/o_circle_basic.nw"

#line 200 "../noweb/o_circle_basic.nw"
/* compute the bounding box and screen coords */
  o_circle_recalc(w_current, new_node);


#line 160 "../noweb/o_circle_basic.nw"

#line 207 "../noweb/o_circle_basic.nw"
/* add the object to the list */
  object_list = (OBJECT *) s_basic_link_object(new_node, object_list);


#line 162 "../noweb/o_circle_basic.nw"
  return (object_list);
}


#line 222 "../noweb/o_circle_basic.nw"
OBJECT *o_circle_copy(TOPLEVEL * w_current, OBJECT * list_tail,
		      OBJECT * o_current)
{
  OBJECT *new_obj;
  ATTRIB *a_current;
  int color;

  if (o_current->saved_color == -1) {
    color = o_current->color;
  } else {
    color = o_current->saved_color;
  }


#line 250 "../noweb/o_circle_basic.nw"
/* create and link a new circle object */
  new_obj = o_circle_add(w_current, list_tail, OBJ_CIRCLE, color, 0, 0, 0);

#line 236 "../noweb/o_circle_basic.nw"


#line 263 "../noweb/o_circle_basic.nw"
/* modify */
  new_obj->circle->center_x = o_current->circle->center_x;
  new_obj->circle->center_y = o_current->circle->center_y;
  new_obj->circle->radius = o_current->circle->radius;

  o_set_line_options(w_current, new_obj, o_current->line_end,
		     o_current->line_type, o_current->line_width,
		     o_current->line_length, o_current->line_space);
  o_set_fill_options(w_current, new_obj,
		     o_current->fill_type, o_current->fill_width,
		     o_current->fill_pitch1, o_current->fill_angle1,
		     o_current->fill_pitch2, o_current->fill_angle2);

  o_circle_recalc(w_current, new_obj);

#line 238 "../noweb/o_circle_basic.nw"


#line 282 "../noweb/o_circle_basic.nw"
/*	new_obj->attribute = 0;*/
  a_current = o_current->attribs;
  if (a_current) {
    while (a_current) {

      /* head attrib node has prev = NULL */
      if (a_current->prev != NULL) {
	a_current->copied_to = new_obj;
      }
      a_current = a_current->next;
    }
  }

#line 241 "../noweb/o_circle_basic.nw"
  return (new_obj);
}


#line 311 "../noweb/o_circle_basic.nw"
void
o_circle_modify(TOPLEVEL * w_current, OBJECT * object,
		int x, int y, int whichone)
{
  switch (whichone) {
  case CIRCLE_CENTER:
    /* modify the center of the circle */
    object->circle->center_x = x;
    object->circle->center_y = y;
    break;
  case CIRCLE_RADIUS:
    /* modify the radius of the circle */
    if (x == 0) {
      s_log_message("Null radius circles are not allowed\n");
      return;
    }
    object->circle->radius = x;
    break;
  default:

    break;
  }

  /* recalculate the screen coords and the boundings */
  o_circle_recalc(w_current, object);

}


#line 358 "../noweb/o_circle_basic.nw"
OBJECT *o_circle_read(TOPLEVEL * w_current, OBJECT * object_list,
		      char buf[], unsigned int release_ver,
		      unsigned int fileformat_ver)
{
  char type;
  int x1, y1;
  int radius;
  int color;
  int circle_width, circle_space, circle_length;
  int fill_width, angle1, pitch1, angle2, pitch2;
  int circle_end;
  int circle_type;
  int circle_fill;

  if (release_ver <= VERSION_20000704) {

#line 393 "../noweb/o_circle_basic.nw"
    sscanf(buf, "%c %d %d %d %d\n", &type, &x1, &y1, &radius, &color);

    circle_width = 0;
    circle_end = END_NONE;
    circle_type = TYPE_SOLID;
    circle_length = -1;
    circle_space = -1;

    circle_fill = FILLING_HOLLOW;
    fill_width = 0;
    angle1 = -1;
    pitch1 = -1;
    angle2 = -1;
    pitch2 = -1;

#line 374 "../noweb/o_circle_basic.nw"

  } else {

#line 414 "../noweb/o_circle_basic.nw"
    sscanf(buf, "%c %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",
	   &type, &x1, &y1, &radius, &color,
	   &circle_width, &circle_end, &circle_type,
	   &circle_length, &circle_space, &circle_fill,
	   &fill_width, &angle1, &pitch1, &angle2, &pitch2);


#line 378 "../noweb/o_circle_basic.nw"
  }


#line 424 "../noweb/o_circle_basic.nw"
  if (radius == 0) {
    fprintf(stderr, "Found a zero radius circle [ %c %d %d %d %d ]\n",
	    type, x1, y1, radius, color);
    s_log_message("Found a zero radius circle [ %c %d %d %d %d ]\n",
		  type, x1, y1, radius, color);

  }

  if (color < 0 || color > MAX_COLORS) {
    fprintf(stderr, "Found an invalid color [ %s ]\n", buf);
    s_log_message("Found an invalid color [ %s ]\n", buf);
    s_log_message("Setting color to WHITE\n");
    color = WHITE;
  }

#line 382 "../noweb/o_circle_basic.nw"

#line 447 "../noweb/o_circle_basic.nw"
  object_list = (OBJECT *) o_circle_add(w_current, object_list,
					type, color, x1, y1, radius);
  o_set_line_options(w_current, object_list,
		     circle_end, circle_type, circle_width,
		     circle_length, circle_space);
  o_set_fill_options(w_current, object_list,
		     circle_fill, fill_width, pitch1, angle1, pitch2,
		     angle2);

#line 383 "../noweb/o_circle_basic.nw"

  return (object_list);
}

#line 468 "../noweb/o_circle_basic.nw"
char *o_circle_save(OBJECT * object)
{
  int x, y;
  int radius;
  int color;
  int circle_width, circle_space, circle_length;
  int fill_width, angle1, pitch1, angle2, pitch2;
  char *buf;
  OBJECT_END circle_end;
  OBJECT_TYPE circle_type;
  OBJECT_FILLING circle_fill;


#line 502 "../noweb/o_circle_basic.nw"
/* circle center and radius */
  x = object->circle->center_x;
  y = object->circle->center_y;
  radius = object->circle->radius;

/* line type parameters */
  circle_width = object->line_width;
  circle_end = object->line_end;
  circle_type = object->line_type;
  circle_length = object->line_length;
  circle_space = object->line_space;

/* filling parameters */
  circle_fill = object->fill_type;
  fill_width = object->fill_width;
  angle1 = object->fill_angle1;
  pitch1 = object->fill_pitch1;
  angle2 = object->fill_angle2;
  pitch2 = object->fill_pitch2;

/* Use the right color */
  if (object->saved_color == -1) {
    color = object->color;
  } else {
    color = object->saved_color;
  }


#line 483 "../noweb/o_circle_basic.nw"
#if 0				/* old system */
  radius = abs(x2 - x1) / 2;
  if (radius == 0) {
    radius = abs(y2 - y1) / 2;
  }

  x = x1 + radius;
  y = y1 - radius;		/* careful */
#endif


#line 533 "../noweb/o_circle_basic.nw"
  buf = g_strdup_printf("%c %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d",
			object->type, x, y, radius, color,
			circle_width, circle_end, circle_type,
			circle_length, circle_space, circle_fill,
			fill_width, angle1, pitch1, angle2, pitch2);


#line 495 "../noweb/o_circle_basic.nw"
  return (buf);
}


#line 551 "../noweb/o_circle_basic.nw"
void
o_circle_translate(TOPLEVEL * w_current, int dx, int dy, OBJECT * object)
{
  int world_dx, world_dy;

  if (object == NULL)
    printf("ct NO!\n");

  /* convert the translation vector in world unit */
  world_dx = SCREENabs(w_current, dx);
  world_dy = SCREENabs(w_current, dy);

  /* translate the circle */
  o_circle_translate_world(w_current, world_dx, world_dy, object);

  /* screen coords and boundings are updated by _translate_world() */

}

#line 579 "../noweb/o_circle_basic.nw"
void
o_circle_translate_world(TOPLEVEL * w_current, int x1, int y1,
			 OBJECT * object)
{
  if (object == NULL)
    printf("ctw NO!\n");


#line 594 "../noweb/o_circle_basic.nw"
/* Do world coords */
  object->circle->center_x = object->circle->center_x + x1;
  object->circle->center_y = object->circle->center_y + y1;


#line 586 "../noweb/o_circle_basic.nw"

#line 602 "../noweb/o_circle_basic.nw"
/* recalc the screen coords and the bounding box */
  o_circle_recalc(w_current, object);


#line 588 "../noweb/o_circle_basic.nw"
}


#line 619 "../noweb/o_circle_basic.nw"
/* takes in screen coordinates for the centerx,y, and then does the rotate 
 * in world space */
/* also ignores angle argument... for now, rotate only in 90 degree 
 * increments */
void
o_circle_rotate(TOPLEVEL * w_current,
		int centerx, int centery, int angle, OBJECT * object)
{
  int world_centerx, world_centery;

  /* convert the center of rotation to world unit */
  SCREENtoWORLD(w_current,
		centerx, centery, &world_centerx, &world_centery);

  /* rotate the circle */
  o_circle_rotate_world(w_current,
			world_centerx, world_centery, angle, object);

  /* screen coords and boundings are updated by _rotate_world() */

}

#line 655 "../noweb/o_circle_basic.nw"
void
o_circle_rotate_world(TOPLEVEL * w_current,
		      int world_centerx, int world_centery, int angle,
		      OBJECT * object)
{
  int newx, newy;
  int x, y;


#line 677 "../noweb/o_circle_basic.nw"
/* angle must be positive */
  if (angle < 0)
    angle = -angle;
/* angle must be a 90 multiple or no rotation performed */
  if ((angle % 90) != 0)
    return;


#line 665 "../noweb/o_circle_basic.nw"

#line 688 "../noweb/o_circle_basic.nw"
/* translate object to origin */
  object->circle->center_x -= world_centerx;
  object->circle->center_y -= world_centery;

/* rotate the center of the circle around the origin */
  x = object->circle->center_x;
  y = object->circle->center_y;
  rotate_point_90(x, y, angle, &newx, &newy);
  object->circle->center_x = newx;
  object->circle->center_y = newy;

/* translate back in position */
  object->circle->center_x += world_centerx;
  object->circle->center_y += world_centery;


#line 667 "../noweb/o_circle_basic.nw"

#line 707 "../noweb/o_circle_basic.nw"
  o_circle_recalc(w_current, object);

#line 668 "../noweb/o_circle_basic.nw"

}


#line 721 "../noweb/o_circle_basic.nw"
void
o_circle_mirror(TOPLEVEL * w_current,
		int centerx, int centery, OBJECT * object)
{
  int world_centerx, world_centery;

  /* convert the origin of mirror */
  SCREENtoWORLD(w_current,
		centerx, centery, &world_centerx, &world_centery);

  /* apply the mirror in world coords */
  o_circle_mirror_world(w_current, world_centerx, world_centery, object);

  /* screen coords and boundings are updated by _mirror_world() */

}

#line 756 "../noweb/o_circle_basic.nw"
void
o_circle_mirror_world(TOPLEVEL * w_current,
		      int world_centerx, int world_centery,
		      OBJECT * object)
{
  /* translate object to origin */
  object->circle->center_x -= world_centerx;
  object->circle->center_y -= world_centery;

  /* mirror the center of the circle */
  object->circle->center_x = -object->circle->center_x;
  object->circle->center_y = object->circle->center_y;

  /* translate back in position */
  object->circle->center_x += world_centerx;
  object->circle->center_y += world_centery;

  /* recalc boundings and screen coords */
  o_circle_recalc(w_current, object);

}


#line 790 "../noweb/o_circle_basic.nw"
void o_circle_recalc(TOPLEVEL * w_current, OBJECT * o_current)
{
  int screen_x1, screen_y1;
  int left, right, top, bottom;

  if (o_current->circle == NULL) {
    return;
  }
#if DEBUG
  printf("drawing circle\n");
#endif


#line 816 "../noweb/o_circle_basic.nw"
/* update the screen coords of the center of the circle */
  WORLDtoSCREEN(w_current,
		o_current->circle->center_x, o_current->circle->center_y,
		&screen_x1, &screen_y1);
  o_current->circle->screen_x = screen_x1;
  o_current->circle->screen_y = screen_y1;

/* update the value of the radius in screen unit */
  o_current->circle->screen_radius = SCREENabs(w_current,
					       o_current->circle->radius);


#line 806 "../noweb/o_circle_basic.nw"

#line 831 "../noweb/o_circle_basic.nw"
/* update the bounding box - screen unit */
  get_circle_bounds(w_current, o_current->circle, &left, &top, &right,
		    &bottom);
  o_current->left = left;
  o_current->top = top;
  o_current->right = right;
  o_current->bottom = bottom;


#line 808 "../noweb/o_circle_basic.nw"

#line 842 "../noweb/o_circle_basic.nw"
/* recalc OBJECT specific parameters */
  o_object_recalc(w_current, o_current);

#line 809 "../noweb/o_circle_basic.nw"

}


#line 857 "../noweb/o_circle_basic.nw"
void
get_circle_bounds(TOPLEVEL * w_current, CIRCLE * circle, int *left,
		  int *top, int *right, int *bottom)
{
  *left = circle->screen_x - circle->screen_radius;
  *top = circle->screen_y - circle->screen_radius;
  *right = circle->screen_x + circle->screen_radius;
  *bottom = circle->screen_y + circle->screen_radius;

  /* PB : need to take into account the width of the line */

  /* out temp  
   *left = *left - 4;
   *top = *top - 4;

   *right = *right + 4;
   *bottom = *bottom + 4;
   */

}

#line 888 "../noweb/o_circle_basic.nw"
void
world_get_circle_bounds(TOPLEVEL * w_current, CIRCLE * circle, int *left,
			int *top, int *right, int *bottom)
{

  *left = w_current->init_right;
  *top = w_current->init_bottom;
  *right = 0;
  *bottom = 0;


  *left = circle->center_x - circle->radius;
  *top = circle->center_y - circle->radius;
  *right = circle->center_x + circle->radius;
  *bottom = circle->center_y + circle->radius;

  /*
   *left = points->x1;
   *top = points->y1;
   *right = points->x1+(temp);
   *bottom = points->y1-(temp); 
   */

  /* 
   *left = min(circle->x1, circle->x1+temp);
   *top = min(circle->y1, circle->y1-temp);
   *right = max(circle->x1, circle->x1+temp);
   *bottom = max(circle->y1, circle->y1-temp);*/

#if DEBUG
  printf("circle: %d %d %d %d\n", *left, *top, *right, *bottom);
#endif

}


#line 940 "../noweb/o_circle_basic.nw"
void
o_circle_print(TOPLEVEL * w_current, FILE * fp, OBJECT * o_current,
	       int origin_x, int origin_y)
{
  int x, y, radius;
  int color;
  int circle_width, length, space;
  int fill_width, angle1, pitch1, angle2, pitch2;
  void (*outl_func) () = NULL;
  void (*fill_func) () = NULL;

  if (o_current == NULL) {
    printf("got null in o_circle_print\n");
    return;
  }

  x = o_current->circle->center_x;
  y = o_current->circle->center_y;
  radius = o_current->circle->radius;

  color = o_current->color;


#line 978 "../noweb/o_circle_basic.nw"
  circle_width = o_current->line_width;
  length = o_current->line_length;
  space = o_current->line_space;

  switch (o_current->line_type) {
  case (TYPE_SOLID):
    length = -1;
    space = -1;
    outl_func = (void *) o_circle_print_solid;
    break;

  case (TYPE_DOTTED):
    length = -1;
    outl_func = (void *) o_circle_print_dotted;
    break;

  case (TYPE_DASHED):
    outl_func = (void *) o_circle_print_dashed;
    break;

  case (TYPE_CENTER):
    outl_func = (void *) o_circle_print_center;
    break;

  case (TYPE_PHANTOM):
    outl_func = (void *) o_circle_print_phantom;
    break;

  case (TYPE_ERASE):
    /* Unused for now print it solid */
    length = -1;
    space = -1;
    outl_func = (void *) o_circle_print_solid;
    break;
  }

  if ((length == 0) || (space == 0)) {
    length = -1;
    space = -1;
    outl_func = (void *) o_circle_print_solid;
  }

  (*outl_func) (w_current, fp,
		x - origin_x, y - origin_y,
		radius,
		color, circle_width, length, space, origin_x, origin_y);

#line 963 "../noweb/o_circle_basic.nw"

#line 1032 "../noweb/o_circle_basic.nw"
  if (o_current->fill_type != FILLING_HOLLOW) {
    fill_width = o_current->fill_width;
    angle1 = o_current->fill_angle1;
    pitch1 = o_current->fill_pitch1;
    angle2 = o_current->fill_angle2;
    pitch2 = o_current->fill_pitch2;

    switch (o_current->fill_type) {
    case (FILLING_FILL):
      angle1 = -1;
      pitch1 = 1;
      angle2 = -1;
      pitch2 = 1;
      fill_width = -1;
      fill_func = (void *) o_circle_print_filled;
      break;

    case (FILLING_MESH):
      fill_func = (void *) o_circle_print_mesh;
      break;

    case (FILLING_HATCH):
      angle2 = -1;
      pitch2 = 1;
      fill_func = (void *) o_circle_print_hatch;
      break;

    case (FILLING_VOID):
      /* Unused for now, print it filled */
      angle1 = -1;
      pitch1 = 1;
      angle2 = -1;
      pitch2 = 1;
      fill_width = -1;
      fill_func = (void *) o_circle_print_filled;
      break;

    case (FILLING_HOLLOW):
      /* nop */
      break;
    }

    if ((pitch1 <= 0) || (pitch2 <= 0)) {
      angle1 = -1;
      pitch1 = 1;
      angle2 = -1;
      pitch2 = 1;
      fill_func = (void *) o_circle_print_filled;
    }

    (*fill_func) (w_current, fp,
		  x, y, radius,
		  color,
		  fill_width,
		  angle1, pitch1, angle2, pitch2, origin_x, origin_y);
  }
#line 964 "../noweb/o_circle_basic.nw"

}

#line 1098 "../noweb/o_circle_basic.nw"
void
o_circle_print_solid(TOPLEVEL * w_current, FILE * fp,
		     int x, int y, int radius,
		     int color,
		     int circle_width, int length, int space,
		     int origin_x, int origin_y)
{

  o_arc_print_solid(w_current, fp,
		    x, y, radius,
		    0, FULL_CIRCLE / 64,
		    color, circle_width, -1, -1, origin_x, origin_y);

}

#line 1130 "../noweb/o_circle_basic.nw"
void
o_circle_print_dotted(TOPLEVEL * w_current, FILE * fp,
		      int x, int y, int radius,
		      int color,
		      int circle_width, int length, int space,
		      int origin_x, int origin_y)
{

  o_arc_print_dotted(w_current, fp,
		     x, y, radius,
		     0, FULL_CIRCLE / 64,
		     color, circle_width, -1, space, origin_x, origin_y);

}

#line 1161 "../noweb/o_circle_basic.nw"
void
o_circle_print_dashed(TOPLEVEL * w_current, FILE * fp,
		      int x, int y,
		      int radius,
		      int color,
		      int circle_width, int length, int space,
		      int origin_x, int origin_y)
{

  o_arc_print_dashed(w_current, fp,
		     x, y, radius,
		     0, FULL_CIRCLE / 64,
		     color,
		     circle_width, length, space, origin_x, origin_y);

}

#line 1193 "../noweb/o_circle_basic.nw"
void
o_circle_print_center(TOPLEVEL * w_current, FILE * fp,
		      int x, int y,
		      int radius,
		      int color,
		      int circle_width, int length, int space,
		      int origin_x, int origin_y)
{

  o_arc_print_center(w_current, fp,
		     x, y, radius,
		     0, FULL_CIRCLE / 64,
		     color,
		     circle_width, length, space, origin_x, origin_y);

}

#line 1225 "../noweb/o_circle_basic.nw"
void
o_circle_print_phantom(TOPLEVEL * w_current, FILE * fp,
		       int x, int y,
		       int radius,
		       int color,
		       int circle_width, int length, int space,
		       int origin_x, int origin_y)
{

  o_arc_print_phantom(w_current, fp,
		      x, y, radius,
		      0, FULL_CIRCLE / 64,
		      color,
		      circle_width, length, space, origin_x, origin_y);

}

#line 1258 "../noweb/o_circle_basic.nw"
void
o_circle_print_filled(TOPLEVEL * w_current, FILE * fp,
		      int x, int y, int radius,
		      int color,
		      int fill_width,
		      int angle1, int pitch1,
		      int angle2, int pitch2, int origin_x, int origin_y)
{
  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, 1);

  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils\n", x - origin_x, y - origin_y);
  fprintf(fp, "%d mils\n", radius);
  fprintf(fp, "0 360 arc\n");
  fprintf(fp, "fill\n");
  fprintf(fp, "grestore\n");

}

#line 1301 "../noweb/o_circle_basic.nw"
void
o_circle_print_mesh(TOPLEVEL * w_current, FILE * fp,
		    int x, int y, int radius,
		    int color,
		    int fill_width,
		    int angle1, int pitch1,
		    int angle2, int pitch2, int origin_x, int origin_y)
{
  o_circle_print_hatch(w_current, fp,
		       x, y, radius,
		       color,
		       fill_width,
		       angle1, pitch1, -1, -1, origin_x, origin_y);
  o_circle_print_hatch(w_current, fp,
		       x, y, radius,
		       color,
		       fill_width,
		       angle2, pitch2, -1, -1, origin_x, origin_y);

}

#line 1346 "../noweb/o_circle_basic.nw"
void
o_circle_print_hatch(TOPLEVEL * w_current, FILE * fp,
		     int x, int y, int radius,
		     int color,
		     int fill_width,
		     int angle1, int pitch1,
		     int angle2, int pitch2, int origin_x, int origin_y)
{
  double x0, y0, x1, y1, x2, y2;
  double cos_a_, sin_a_;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, fill_width);

#line 1371 "../noweb/o_circle_basic.nw"
  cos_a_ = cos(((double) angle1) * M_PI / 180);
  sin_a_ = sin(((double) angle1) * M_PI / 180);


#line 1390 "../noweb/o_circle_basic.nw"
  y0 = 0;
  while (y0 < (double) radius) {
    x0 = pow((double) radius, 2) - pow(y0, 2);
    x0 = sqrt(x0);

    x1 = (x0 * cos_a_ - y0 * sin_a_) + x;
    y1 = y + (x0 * sin_a_ + y0 * cos_a_);
    x2 = ((-x0) * cos_a_ - y0 * sin_a_) + x;
    y2 = y + ((-x0) * sin_a_ + y0 * cos_a_);

    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) x1, (int) y1);
    fprintf(fp, "%d mils %d mils lineto\n", (int) x2, (int) y2);
    fprintf(fp, "stroke\n");



#line 1412 "../noweb/o_circle_basic.nw"
    x1 = x + (x0 * cos_a_ - (-y0) * sin_a_);
    y1 = y + (x0 * sin_a_ + (-y0) * cos_a_);
    x2 = x + ((-x0) * cos_a_ - (-y0) * sin_a_);
    y2 = y + ((-x0) * sin_a_ + (-y0) * cos_a_);

    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) x1, (int) y1);
    fprintf(fp, "%d mils %d mils lineto\n", (int) x2, (int) y2);
    fprintf(fp, "stroke\n");


    y0 = y0 + pitch1;
  }

#line 1376 "../noweb/o_circle_basic.nw"
  fprintf(fp, "grestore\n");

}

#line 50 "../noweb/o_circle_basic.nw"
#if 0				/* original way of printing circle, no longer used */
#line 1435 "../noweb/o_circle_basic.nw"
void
o_circle_print_old(TOPLEVEL * w_current, FILE * fp, OBJECT * o_current,
		   int origin_x, int origin_y)
{
  if (o_current == NULL) {
    printf("got null in o_circle_print\n");
    return;
  }

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, o_current->color);
  }

  f_print_set_line_width(fp, o_current->line_width);

  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils\n", o_current->circle->center_x - origin_x,
	  o_current->circle->center_y - origin_y);
  fprintf(fp, "%d mils\n", o_current->circle->radius);
  fprintf(fp, "0 360 arc\n");
  fprintf(fp, "stroke\n");
  fprintf(fp, "grestore\n");
}

#line 52 "../noweb/o_circle_basic.nw"
#endif

#line 1470 "../noweb/o_circle_basic.nw"
void
o_circle_image_write(TOPLEVEL * w_current, OBJECT * o_current,
		     int origin_x, int origin_y, int color_mode)
{
  int color;

  if (o_current == NULL) {
    printf("got null in o_circle_image_write\n");
    return;
  }

  if (color_mode == TRUE) {
    color = o_image_geda2gd_color(o_current->color);
  } else {
    color = image_black;
  }

#ifdef HAS_LIBGDGEDA

  gdImageSetThickness(current_im_ptr, SCREENabs(w_current,
						o_current->line_width));

  gdImageArc(current_im_ptr,
	     o_current->circle->screen_x,
	     o_current->circle->screen_y,
	     SCREENabs(w_current, o_current->circle->radius) * 2,
	     SCREENabs(w_current, o_current->circle->radius) * 2,
	     0, 360, color);
#endif

}
