/* testfixture.vala
 *
 * Copyright (C) 2009 Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TEST_FIXTURE (test_fixture_get_type ())
#define TEST_FIXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_FIXTURE, TestFixture))
#define TEST_FIXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_FIXTURE, TestFixtureClass))
#define IS_TEST_FIXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_FIXTURE))
#define IS_TEST_FIXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_FIXTURE))
#define TEST_FIXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_FIXTURE, TestFixtureClass))

typedef struct _TestFixture TestFixture;
typedef struct _TestFixtureClass TestFixtureClass;
typedef struct _TestFixturePrivate TestFixturePrivate;

#define TEST_FIXTURE_TYPE_TEST_ADAPTOR (test_fixture_test_adaptor_get_type ())
#define TEST_FIXTURE_TEST_ADAPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TEST_FIXTURE_TYPE_TEST_ADAPTOR, TestFixtureTestAdaptor))
#define TEST_FIXTURE_TEST_ADAPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TEST_FIXTURE_TYPE_TEST_ADAPTOR, TestFixtureTestAdaptorClass))
#define TEST_FIXTURE_IS_TEST_ADAPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TEST_FIXTURE_TYPE_TEST_ADAPTOR))
#define TEST_FIXTURE_IS_TEST_ADAPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TEST_FIXTURE_TYPE_TEST_ADAPTOR))
#define TEST_FIXTURE_TEST_ADAPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TEST_FIXTURE_TYPE_TEST_ADAPTOR, TestFixtureTestAdaptorClass))

typedef struct _TestFixtureTestAdaptor TestFixtureTestAdaptor;
typedef struct _TestFixtureTestAdaptorClass TestFixtureTestAdaptorClass;
typedef struct _TestFixtureTestAdaptorPrivate TestFixtureTestAdaptorPrivate;
typedef struct _TestFixtureParamSpecTestAdaptor TestFixtureParamSpecTestAdaptor;

struct _TestFixture {
	GObject parent_instance;
	TestFixturePrivate * priv;
};

struct _TestFixtureClass {
	GObjectClass parent_class;
	void (*setup) (TestFixture* self);
	void (*teardown) (TestFixture* self);
};

struct _TestFixturePrivate {
	GTestSuite* suite;
	TestFixtureTestAdaptor** adaptors;
	gint adaptors_length1;
	gint adaptors_size;
};

typedef void (*TestFixtureTestMethod) (void* user_data);
struct _TestFixtureTestAdaptor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestFixtureTestAdaptorPrivate * priv;
};

struct _TestFixtureTestAdaptorClass {
	GTypeClass parent_class;
	void (*finalize) (TestFixtureTestAdaptor *self);
};

struct _TestFixtureTestAdaptorPrivate {
	char* _name;
	TestFixtureTestMethod test;
	gpointer test_target;
	TestFixture* fixture;
};

struct _TestFixtureParamSpecTestAdaptor {
	GParamSpec parent_instance;
};


static gpointer test_fixture_test_adaptor_parent_class = NULL;
static gpointer test_fixture_parent_class = NULL;

GType test_fixture_get_type (void);
static gpointer test_fixture_test_adaptor_ref (gpointer instance);
static void test_fixture_test_adaptor_unref (gpointer instance);
static GParamSpec* test_fixture_param_spec_test_adaptor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
static void test_fixture_value_set_test_adaptor (GValue* value, gpointer v_object);
static gpointer test_fixture_value_get_test_adaptor (const GValue* value);
static GType test_fixture_test_adaptor_get_type (void);
#define TEST_FIXTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_FIXTURE, TestFixturePrivate))
enum  {
	TEST_FIXTURE_DUMMY_PROPERTY
};
TestFixture* test_fixture_new (const char* name);
TestFixture* test_fixture_construct (GType object_type, const char* name);
static TestFixtureTestAdaptor* test_fixture_test_adaptor_new (const char* name, TestFixtureTestMethod test, void* test_target, TestFixture* fixture);
static TestFixtureTestAdaptor* test_fixture_test_adaptor_construct (GType object_type, const char* name, TestFixtureTestMethod test, void* test_target, TestFixture* fixture);
static void _vala_array_add1 (TestFixtureTestAdaptor*** array, int* length, int* size, TestFixtureTestAdaptor* value);
static const char* test_fixture_test_adaptor_get_name (TestFixtureTestAdaptor* self);
static void test_fixture_test_adaptor_setup (TestFixtureTestAdaptor* self, void* fixture);
static void _test_fixture_test_adaptor_setup_gtest_func (void* fixture, gpointer self);
static void test_fixture_test_adaptor_run (TestFixtureTestAdaptor* self, void* fixture);
static void _test_fixture_test_adaptor_run_gtest_func (void* fixture, gpointer self);
static void test_fixture_test_adaptor_teardown (TestFixtureTestAdaptor* self, void* fixture);
static void _test_fixture_test_adaptor_teardown_gtest_func (void* fixture, gpointer self);
void test_fixture_add_test (TestFixture* self, const char* name, TestFixtureTestMethod test, void* test_target);
void test_fixture_setup (TestFixture* self);
static void test_fixture_real_setup (TestFixture* self);
void test_fixture_teardown (TestFixture* self);
static void test_fixture_real_teardown (TestFixture* self);
GTestSuite* test_fixture_get_suite (TestFixture* self);
void test_fixture_add_to_suite (TestFixture* self, GTestSuite* suite);
#define TEST_FIXTURE_TEST_ADAPTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TEST_FIXTURE_TYPE_TEST_ADAPTOR, TestFixtureTestAdaptorPrivate))
enum  {
	TEST_FIXTURE_TEST_ADAPTOR_DUMMY_PROPERTY
};
static void test_fixture_test_adaptor_set_name (TestFixtureTestAdaptor* self, const char* value);
static void test_fixture_test_adaptor_finalize (TestFixtureTestAdaptor* obj);
static void test_fixture_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



TestFixture* test_fixture_construct (GType object_type, const char* name) {
	TestFixture * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->suite = g_test_create_suite (name);
	return self;
}


TestFixture* test_fixture_new (const char* name) {
	return test_fixture_construct (TYPE_TEST_FIXTURE, name);
}


static void _vala_array_add1 (TestFixtureTestAdaptor*** array, int* length, int* size, TestFixtureTestAdaptor* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TestFixtureTestAdaptor*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _test_fixture_test_adaptor_setup_gtest_func (void* fixture, gpointer self) {
	test_fixture_test_adaptor_setup (self, fixture);
}


static void _test_fixture_test_adaptor_run_gtest_func (void* fixture, gpointer self) {
	test_fixture_test_adaptor_run (self, fixture);
}


static void _test_fixture_test_adaptor_teardown_gtest_func (void* fixture, gpointer self) {
	test_fixture_test_adaptor_teardown (self, fixture);
}


void test_fixture_add_test (TestFixture* self, const char* name, TestFixtureTestMethod test, void* test_target) {
	TestFixtureTestAdaptor* adaptor;
	TestFixtureTestAdaptor* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	adaptor = test_fixture_test_adaptor_new (name, test, test_target, self);
	_tmp0_ = NULL;
	_vala_array_add1 (&self->priv->adaptors, &self->priv->adaptors_length1, &self->priv->adaptors_size, (_tmp0_ = adaptor, (_tmp0_ == NULL) ? NULL : test_fixture_test_adaptor_ref (_tmp0_)));
	g_test_suite_add (self->priv->suite, g_test_create_case (test_fixture_test_adaptor_get_name (adaptor), (gsize) 0, adaptor, _test_fixture_test_adaptor_setup_gtest_func, _test_fixture_test_adaptor_run_gtest_func, _test_fixture_test_adaptor_teardown_gtest_func));
	(adaptor == NULL) ? NULL : (adaptor = (test_fixture_test_adaptor_unref (adaptor), NULL));
}


static void test_fixture_real_setup (TestFixture* self) {
	g_return_if_fail (self != NULL);
}


void test_fixture_setup (TestFixture* self) {
	TEST_FIXTURE_GET_CLASS (self)->setup (self);
}


static void test_fixture_real_teardown (TestFixture* self) {
	g_return_if_fail (self != NULL);
}


void test_fixture_teardown (TestFixture* self) {
	TEST_FIXTURE_GET_CLASS (self)->teardown (self);
}


GTestSuite* test_fixture_get_suite (TestFixture* self) {
	GTestSuite* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->suite;
	return result;
}


void test_fixture_add_to_suite (TestFixture* self, GTestSuite* suite) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (suite != NULL);
	g_test_suite_add_suite (suite, self->priv->suite);
}


static TestFixtureTestAdaptor* test_fixture_test_adaptor_construct (GType object_type, const char* name, TestFixtureTestMethod test, void* test_target, TestFixture* fixture) {
	TestFixtureTestAdaptor* self;
	TestFixtureTestMethod _tmp0_;
	TestFixture* _tmp2_;
	TestFixture* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (fixture != NULL, NULL);
	self = (TestFixtureTestAdaptor*) g_type_create_instance (object_type);
	test_fixture_test_adaptor_set_name (self, name);
	self->priv->test = (_tmp0_ = test, self->priv->test_target = test_target, _tmp0_);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->fixture = (_tmp2_ = (_tmp1_ = fixture, (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_)), (self->priv->fixture == NULL) ? NULL : (self->priv->fixture = (g_object_unref (self->priv->fixture), NULL)), _tmp2_);
	return self;
}


static TestFixtureTestAdaptor* test_fixture_test_adaptor_new (const char* name, TestFixtureTestMethod test, void* test_target, TestFixture* fixture) {
	return test_fixture_test_adaptor_construct (TEST_FIXTURE_TYPE_TEST_ADAPTOR, name, test, test_target, fixture);
}


static void test_fixture_test_adaptor_setup (TestFixtureTestAdaptor* self, void* fixture) {
	g_return_if_fail (self != NULL);
	test_fixture_setup (self->priv->fixture);
}


static void test_fixture_test_adaptor_run (TestFixtureTestAdaptor* self, void* fixture) {
	g_return_if_fail (self != NULL);
	self->priv->test (self->priv->test_target);
}


static void test_fixture_test_adaptor_teardown (TestFixtureTestAdaptor* self, void* fixture) {
	g_return_if_fail (self != NULL);
	test_fixture_teardown (self->priv->fixture);
}


static const char* test_fixture_test_adaptor_get_name (TestFixtureTestAdaptor* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


static void test_fixture_test_adaptor_set_name (TestFixtureTestAdaptor* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_name = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp1_);
}


static void test_fixture_value_test_adaptor_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void test_fixture_value_test_adaptor_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_fixture_test_adaptor_unref (value->data[0].v_pointer);
	}
}


static void test_fixture_value_test_adaptor_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_fixture_test_adaptor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer test_fixture_value_test_adaptor_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* test_fixture_value_test_adaptor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestFixtureTestAdaptor* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_fixture_test_adaptor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* test_fixture_value_test_adaptor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestFixtureTestAdaptor** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_fixture_test_adaptor_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* test_fixture_param_spec_test_adaptor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TestFixtureParamSpecTestAdaptor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TEST_FIXTURE_TYPE_TEST_ADAPTOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer test_fixture_value_get_test_adaptor (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TEST_FIXTURE_TYPE_TEST_ADAPTOR), NULL);
	return value->data[0].v_pointer;
}


static void test_fixture_value_set_test_adaptor (GValue* value, gpointer v_object) {
	TestFixtureTestAdaptor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TEST_FIXTURE_TYPE_TEST_ADAPTOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TEST_FIXTURE_TYPE_TEST_ADAPTOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_fixture_test_adaptor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_fixture_test_adaptor_unref (old);
	}
}


static void test_fixture_test_adaptor_class_init (TestFixtureTestAdaptorClass * klass) {
	test_fixture_test_adaptor_parent_class = g_type_class_peek_parent (klass);
	TEST_FIXTURE_TEST_ADAPTOR_CLASS (klass)->finalize = test_fixture_test_adaptor_finalize;
	g_type_class_add_private (klass, sizeof (TestFixtureTestAdaptorPrivate));
}


static void test_fixture_test_adaptor_instance_init (TestFixtureTestAdaptor * self) {
	self->priv = TEST_FIXTURE_TEST_ADAPTOR_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void test_fixture_test_adaptor_finalize (TestFixtureTestAdaptor* obj) {
	TestFixtureTestAdaptor * self;
	self = TEST_FIXTURE_TEST_ADAPTOR (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->fixture == NULL) ? NULL : (self->priv->fixture = (g_object_unref (self->priv->fixture), NULL));
}


static GType test_fixture_test_adaptor_get_type (void) {
	static GType test_fixture_test_adaptor_type_id = 0;
	if (test_fixture_test_adaptor_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { test_fixture_value_test_adaptor_init, test_fixture_value_test_adaptor_free_value, test_fixture_value_test_adaptor_copy_value, test_fixture_value_test_adaptor_peek_pointer, "p", test_fixture_value_test_adaptor_collect_value, "p", test_fixture_value_test_adaptor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestFixtureTestAdaptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_fixture_test_adaptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestFixtureTestAdaptor), 0, (GInstanceInitFunc) test_fixture_test_adaptor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		test_fixture_test_adaptor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestFixtureTestAdaptor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return test_fixture_test_adaptor_type_id;
}


static gpointer test_fixture_test_adaptor_ref (gpointer instance) {
	TestFixtureTestAdaptor* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void test_fixture_test_adaptor_unref (gpointer instance) {
	TestFixtureTestAdaptor* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_FIXTURE_TEST_ADAPTOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void test_fixture_class_init (TestFixtureClass * klass) {
	test_fixture_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TestFixturePrivate));
	TEST_FIXTURE_CLASS (klass)->setup = test_fixture_real_setup;
	TEST_FIXTURE_CLASS (klass)->teardown = test_fixture_real_teardown;
	G_OBJECT_CLASS (klass)->finalize = test_fixture_finalize;
}


static void test_fixture_instance_init (TestFixture * self) {
	self->priv = TEST_FIXTURE_GET_PRIVATE (self);
	self->priv->adaptors = g_new0 (TestFixtureTestAdaptor*, 0 + 1);
	self->priv->adaptors_length1 = 0;
}


static void test_fixture_finalize (GObject* obj) {
	TestFixture * self;
	self = TEST_FIXTURE (obj);
	self->priv->adaptors = (_vala_array_free (self->priv->adaptors, self->priv->adaptors_length1, (GDestroyNotify) test_fixture_test_adaptor_unref), NULL);
	G_OBJECT_CLASS (test_fixture_parent_class)->finalize (obj);
}


GType test_fixture_get_type (void) {
	static GType test_fixture_type_id = 0;
	if (test_fixture_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TestFixtureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_fixture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestFixture), 0, (GInstanceInitFunc) test_fixture_instance_init, NULL };
		test_fixture_type_id = g_type_register_static (G_TYPE_OBJECT, "TestFixture", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return test_fixture_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




