// MFINDER.CPP

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "libghemicalconfig2.h"
#include "mfinder.h"

#include "v3d.h"

#include <string.h>

#include <iomanip>
#include <iostream>
#include <sstream>
using namespace std;

/*################################################################################################*/

mfinder::mfinder(char * filename)
{
	ifstream file;
	file.unsetf(ios::dec | ios::oct | ios::hex);
	
	model::OpenLibDataFile(file, false, filename);
	
	// read information about the main chain...
	
	while (file.peek() != 'M') file.getline(buffer, sizeof(buffer));
	file.getline(buffer, sizeof(buffer));
	
	while (file.peek() != 'E')
	{
		mf_data_atm newatm; file >> newatm;
		while (file.peek() != '(') file.get();
		newatm.tr = new typerule(& file, & cout);
		file.getline(buffer, sizeof(buffer));
		main_vector.push_back(newatm);
	}
	
	while (file.peek() != 'C') file.getline(buffer, sizeof(buffer));
	file.getline(buffer, sizeof(buffer));
	
	while (file.peek() != 'E')
	{
		mf_data_atm newatm; file >> newatm;
		while (file.peek() != '(') file.get();
		newatm.tr = new typerule(& file, & cout);
		file.getline(buffer, sizeof(buffer));
		conn_vector.push_back(newatm);
	}
	
	// read descriptions about the chain initiation...
	
	while (file.peek() != 'H') file.getline(buffer, sizeof(buffer));
	file.getline(buffer, sizeof(buffer));
	
	while (file.peek() != 'E')
	{
		typerule newrule = typerule(& file, & cout);
		file.getline(buffer, sizeof(buffer));
		head_vector.push_back(newrule);
	}
	
	// read descriptions about the chain termination...
	
	while (file.peek() != 'T') file.getline(buffer, sizeof(buffer));
	file.getline(buffer, sizeof(buffer));
	
	while (file.peek() != 'E')
	{
		typerule newrule = typerule(& file, & cout);
		file.getline(buffer, sizeof(buffer));
		tail_vector.push_back(newrule);
	}
	
	// read the default modifications for residues...
	
//	while (file.peek() != 'B') file.getline(buffer, sizeof(buffer));	// default...
//	file.getline(buffer, sizeof(buffer)); mod[0] = new mb_data_res; mod[0]->ReadModification(file);
	
//	while (file.peek() != 'H') file.getline(buffer, sizeof(buffer));	// head-mods
//	file.getline(buffer, sizeof(buffer)); mod[1] = new mb_data_res; mod[1]->ReadModification(file);
	
//	while (file.peek() != 'T') file.getline(buffer, sizeof(buffer));	// tail-mods
//	file.getline(buffer, sizeof(buffer)); mod[2] = new mb_data_res; mod[2]->ReadModification(file);
	
	// read descriptions for the residues...
	
	while (file.peek() != 'E')
	{
		if (file.peek() == 'R')
		{
		//	mb_data_res newres; file >> newres;
		//	resi_vector.push_back(newres);
		}
		else file.getline(buffer, sizeof(buffer));
	}
	
	// ready!!!
	
	file.close();
}

mfinder::~mfinder(void)
{
//	delete mod[0];
//	delete mod[1];
//	delete mod[2];
}

// here we will identify the molecules (if there is any), write down the molecules
// into model::ref_civ and update the /mol/chn/res-numbering...

// only model::UpdateChains() should call this???
// only model::UpdateChains() should call this???
// only model::UpdateChains() should call this???

void mfinder::Identify(model * mdl)
{
	if (!mdl->IsGroupsClean())
	{
		cout << "BUG: is_groups_clean was false at mfinder::Identify()." << endl;
		exit(EXIT_FAILURE);	//mdl->UpdateGroups();
	}
	
	if (mdl->ref_civ == NULL)
	{
		cout << "BUG: mdl->ref_civ == NULL at mfinder::Identify()." << endl;
		exit(EXIT_FAILURE);
	}
	
cout << "mfinder::Identify() starts..." << endl;
cout << "nmol = " << mdl->nmol << endl;
	
	// here we will find all possible chains and identify them.
	
	for (i32s n1 = 0;n1 < mdl->nmol;n1++)
	{
		iter_al range[2];
		mdl->GetRange(0, n1, range);
		
		vector<atom *> head_atoms;
		vector<atom *> tail_atoms;
		
		for (iter_al it1 = range[0];it1 != range[1];it1++)
		{
			i32s tmp1 = (* it1).el.GetAtomicNumber();
			
			if (tmp1 == main_vector.front().el.GetAtomicNumber())		// look for heads...
			{
				for (i32u n2 = 0;n2 < head_vector.size();n2++)
				{
					bool flag = head_vector[n2].Check(mdl, & (* it1), 0);
					if (!flag) continue; head_atoms.push_back(& (* it1)); break;
				}
			}
			
			if (tmp1 == main_vector.back().el.GetAtomicNumber())		// look for tails...
			{
				for (i32u n2 = 0;n2 < tail_vector.size();n2++)
				{
					bool flag = tail_vector[n2].Check(mdl, & (* it1), 0);
					if (!flag) continue; tail_atoms.push_back(& (* it1)); break;
				}
			}
		}
		
		if (head_atoms.size() > 0 && tail_atoms.size() > 0)
		{
			cout << "found " << head_atoms.size() << " possible heads and ";
			cout << tail_atoms.size() << " possible tails." << endl;
		}
		
		// now we have all possible head/tail atoms. next we have to check
		// all possible paths between them to find all possible main chains...
		
		path_vector.resize(0);
		for (i32u n2 = 0;n2 < head_atoms.size();n2++)
		{
			for (i32u n3 = 0;n3 < tail_atoms.size();n3++)
			{
				FindPath(mdl, head_atoms[n2], tail_atoms[n3]);
			}
		}
		
		if (path_vector.size())
		{
			cout << path_vector.size() << " chains:" << endl;
		}
		
		for (i32s n2 = 0;n2 < (i32s) path_vector.size();n2++)
		{
			for (i32s n3 = 0;n3 < ((i32s) path_vector[n2].size()) - 1;n3++)		// tag the main-chain bonds...
			{
				iter_cl it1 = path_vector[n2][n3]->GetConnRecsBegin();
				while ((* it1).atmr != path_vector[n2][n3 + 1]) it1++;
				(* it1).bndr->flags[0] = true;
			}
			
		//seq	vector<char> molecule;
			
			i32u acount = 0;	// atom counter
			i32u rcount = 0;	// residue counter
			
			while (acount < path_vector[n2].size())
			{
				// rsize is the residue size (how many atoms it will chop away from the
				// path_vector). we use it to determine whether we have reached the last
				// residue, and to increment acount.
				
				int head_el = NOT_DEFINED;
				int tail_el = NOT_DEFINED;
				
				bool is_first = !rcount;
			//	if (is_first && type == chn_info::amino_acid)
			//	{
			//		// an extra test for an ACE-like block group.
			//		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
			//		
			//		atom * refA = path_vector[n2][acount + 0];
			//		atom * refB = path_vector[n2][acount + 1];
			//		atom * refX = NULL;
			//		
			//		for (iter_cl itX = refA->cr_list.begin();itX != refA->cr_list.end();itX++)
			//		{
			//			if ((* itX).atmr->el.GetAtomicNumber() <= 1) continue;
			//			if ((* itX).atmr == refB) continue;
			//			
			//			refX = (* itX).atmr;
			//		}
			//		
			//		if (refX != NULL)
			//		{
			//			head_el = refX->el.GetAtomicNumber();
			//			is_first = false;
			//		}
			//	}
				
				bool is_last = (acount + main_vector.size() + conn_vector.size()) >= path_vector[n2].size();
			//	if (is_last && type == chn_info::amino_acid)
			//	{
			//		// an extra test for an NME-like block group.
			//		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
			//		
			//		atom * refA = path_vector[n2][acount + 2];
			//		atom * refB = path_vector[n2][acount + 1];
			//		atom * refX = NULL;
			//		
			//		for (iter_cl itX = refA->cr_list.begin();itX != refA->cr_list.end();itX++)
			//		{
			//			if ((* itX).bndr->bt.GetValue() != 1) continue;
			//			if ((* itX).atmr == refB) continue;
			//			
			//			refX = (* itX).atmr;
			//		}
			//		
			//		if (refX != NULL)
			//		{
			//			tail_el = refX->el.GetAtomicNumber();
			//			is_last = false;
			//		}
			//	}
				
				i32u rsize = main_vector.size();
				if (!is_last) rsize += conn_vector.size();
				
				// now we start identifying the residues.
				
				// we make a simple template for each of them, compare those to
				// the residue descriptions we have, and pick the closest match.
				// there may not be any missing atoms, and the closest match is
				// the one with largest number of correct atoms identified.
				
				i32s tmp1[2] = { NOT_DEFINED, NOT_DEFINED };
			/*	for (i32s n4 = 0;n4 < (i32s) resi_vector.size();n4++)
				{
					vector<mb_tdata> tdata;
					BuildTemplate(tdata, n4, is_first, is_last);
					
					// do the template mods if blockgroups!!!
					// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
					
					if (head_el != NOT_DEFINED)
					{
						if (is_first)
						{
							cout << "bad head_el" << endl;
							exit(EXIT_FAILURE);
						}
						
						// ACE needs no modifications...
					}
					
					if (tail_el != NOT_DEFINED)
					{
						if (is_last)
						{
							cout << "bad tail_el" << endl;
							exit(EXIT_FAILURE);
						}
						
						for (i32s n5 = 0;n5 < (i32s) tdata.size();n5++)
						{
							if (tdata[n5].id[0] == 0x11)
							{
								tdata[n5].el = element(tail_el);
							}
						}
					}
					
					// set the main chain stuff...
					
					for (i32s n5 = 0;n5 < (i32s) main_vector.size();n5++)
					{
						tdata[n5].ref = path_vector[n2][acount + n5];
					}
					
					// set the connection stuff...
					
					if (!is_last)
					{
						const int mvsz = main_vector.size();
						for (i32s n5 = 0;n5 < (i32s) conn_vector.size();n5++)
						{
							tdata[mvsz + n5].ref = path_vector[n2][acount + mvsz + n5];
						}
					}
					
					bool result = CheckTemplate(tdata, 0);
///////////////////////////////////////////////////////////////////////////////////////////
//cout << "checktemplate " << n4 << " " << is_first << " " << is_last << " ; ";
//cout << "result = " << result << endl;
//int zzz; cin >> zzz;
///////////////////////////////////////////////////////////////////////////////////////////
					if (result && (tmp1[0] == NOT_DEFINED || ((i32s) tdata.size()) > tmp1[1]))
					{
						tmp1[0] = n4;
						tmp1[1] = (i32s) tdata.size();
					}
				}	*/
				
				if (tmp1[0] == NOT_DEFINED)
				{
					cout << "WARNING : residue " << rcount << " was of unknown type!!!" << endl;
					
				//seq	molecule.push_back('?');				// handle the molecule...
					
					for (i32u n3 = 0;n3 < main_vector.size();n3++)		// handle the numbers...
					{
						path_vector[n2][acount + n3]->builder_res_id = NOT_DEFINED;	// WHAT HERE???
						
						path_vector[n2][acount + n3]->id[1] = mdl->ref_civ->size();
						path_vector[n2][acount + n3]->id[2] = rcount;
					}
				}
				else
				{
				//	molecule.push_back(resi_vector[tmp1[0]].symbol1);
					
					// rebuild the best matching template and use that to
					// set up the atom ID numbers...
					
					vector<mf_tdata> tdata;
					BuildTemplate(tdata, tmp1[0], is_first, is_last);
					
					for (i32s n4 = 0;n4 < (i32s) main_vector.size();n4++)
					{
						tdata[n4].ref = path_vector[n2][acount + n4];
					}
					
					if (!is_last)
					{
						const int mvsz = main_vector.size();
						for (i32s n5 = 0;n5 < (i32s) conn_vector.size();n5++)
						{
							tdata[mvsz + n5].ref = path_vector[n2][acount + mvsz + n5];
						}
					}
					
					CheckTemplate(tdata, 0);
					for (i32s n4 = 0;n4 < (i32s) tdata.size();n4++)
					{
					//	tdata[n4].ref->builder_res_id = (resi_vector[tmp1[0]].id << 8) + tdata[n4].id[0];
						
					//	tdata[n4].ref->id[1] = mdl->ref_civ->size();
					//	tdata[n4].ref->id[2] = rcount;
					}
					
/////////////////////////////////////////////////////////////////////////// exceptions
/////////////////////////////////////////////////////////////////////////// exceptions
					
				}
				
				rcount++;
				acount += rsize;
			}
			
		//	// next we will write down the molecule...
		//	
		//	chn_info newinfo(type, molecule.size());
		//	
		//	newinfo.id_mol = n1;
		//	newinfo.id_chn = mdl->ref_civ->size();
		//	
		//	for (i32u n3 = 0;n3 < molecule.size();n3++) newinfo.molecule[n3] = molecule[n3];
		//	
		//	mdl->ref_civ->push_back(newinfo);
		//	
		//	// and make some output (using FASTA format again)...
		//	
		//	cout << "> chain " << newinfo.id_chn;
		//	cout << ", length " << newinfo.length << ":" << endl;
		//	
		//	for (i32u n3 = 0;n3 < molecule.size();n3++)
		//	{
		//		cout << molecule[n3];
		//		
		//		bool is_break = !((n3 + 1) % 50);
		//		bool is_end = ((n3 + 1) == molecule.size());
		//		
		//		if (is_break || is_end) cout << endl;
		//	}
		//	
		//	// finally un-tag the main-chain bonds...
		//	
		//	for (i32s n3 = 0;n3 < ((i32s) path_vector[n2].size()) - 1;n3++)
		//	{
		//		iter_cl it1 = path_vector[n2][n3]->cr_list.begin();
		//		while ((* it1).atmr != path_vector[n2][n3 + 1]) it1++;
		//		(* it1).bndr->flags[0] = false;
		//	}
		}
// obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete
// obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete
	/*	now check the HYDROGENS that are ignored by the seqbuilder generally.
		for hydrogens, set the same id's that the heavy atom has if they are valid ones.
		for (iter_al it1 = range[0];it1 != range[1];it1++)
		{
			if ((* it1).el.GetAtomicNumber() != 1) continue;
			
			if ((* it1).cr_list.size() != 1)
			{
				cout << "WARNING : seqbuild : H atom with abnormal connectivity found." << endl;
				continue;
			}
			
			atom * heavy = (* it1).cr_list.front().atmr;
			if (heavy->id[1] < 0) continue;		// id < 0 means NOT_DEFINED...
			if (heavy->id[2] < 0) continue;		// id < 0 means NOT_DEFINED...
			
			// ok, set the heavy atom id's to hydrogen as well...
			
			(* it1).id[1] = heavy->id[1];
			(* it1).id[2] = heavy->id[2];
		}	*/
// obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete
// obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete obsolete
	}
	
	// traditionally, we sorted the atom list here to make the newly assigned chains in nice order.
	// nowadays, this is done at model::UpdateChains() since there might be many different seqbuilder
	// objects (like for amino/nucleic acid variants) and we like to use them all...
}

void mfinder::BuildTemplate(vector<mf_tdata> & tdata, i32s res, bool is_first, bool is_last)
{
	BuildPartialT(tdata, main_vector);
	if (!is_last) BuildPartialT(tdata, conn_vector);
	
//	if (is_last) BuildPartialT(tdata, mod[2]->atm_vector);		// tail-mods
//	else if (is_first) BuildPartialT(tdata, mod[1]->atm_vector);	// head-mods
//	else BuildPartialT(tdata, mod[0]->atm_vector);			// default...
	
//	BuildPartialT(tdata, resi_vector[res].atm_vector);
}

void mfinder::BuildPartialT(vector<mf_tdata> & tdata, vector<mf_data_atm> & adata)
{
	for (i32u n1 = 0;n1 < adata.size();n1++)
	{
		mf_tdata newdata;
		newdata.id[0] = adata[n1].id;
		
		if (adata[n1].prev[0] & 0xFF00) newdata.id[1] = NOT_DEFINED;
		else newdata.id[1] = adata[n1].prev[0];
		
		newdata.el = adata[n1].el;
		newdata.bt = adata[n1].bt;
		newdata.ref = NULL;
		
		tdata.push_back(newdata);
	}
}

// idea is that this path-searching function should be used only inside a molecule.
// this way we are sure to find always at least one path. we collect references to
// atoms for all paths and collect this way all possible paths.

// different flags should be used in type checking and in this path-searching...

void mfinder::FindPath(model * mdl, atom * ref1, atom * ref2, i32u index)
{
	if (index >= main_vector.size() + conn_vector.size()) index = 0;
	
	if (index < main_vector.size())
	{
		if (ref1->el.GetAtomicNumber() != main_vector[index].el.GetAtomicNumber()) return;
		if (!main_vector[index].tr->Check(mdl, ref1, 0)) return;
	}
	else
	{
		i32u index2 = index - main_vector.size();
		
		if (ref1->el.GetAtomicNumber() != conn_vector[index2].el.GetAtomicNumber()) return;
		if (!conn_vector[index2].tr->Check(mdl, ref1, 0)) return;
	}
	
	temporary_vector.push_back(ref1);
	
//for (i32u debug = 0;debug < temporary_vector.size();debug++)
//{
//	cout << temporary_vector[debug]->el.GetSymbol();
//}	cout << endl;
	
	if (ref1 == ref2) path_vector.push_back(temporary_vector);
	else
	{
		for (iter_cl it1 = ref1->GetConnRecsBegin();it1 != ref1->GetConnRecsEnd();it1++)
		{
			if ((* it1).bndr->flags[2]) continue;
			
			(* it1).bndr->flags[2] = true;
			FindPath(mdl, (* it1).atmr, ref2, (index + 1));
			(* it1).bndr->flags[2] = false;
		}
	}
	
	temporary_vector.pop_back();
}

bool mfinder::CheckTemplate(vector<mf_tdata> & tdata, i32s flag)
{
// miten antaa vinkki atomista nolla??? sehn on "hotspot"???
// olisko templaatti "esitytetty" sen alun osalta???????????
	vector<i32s> tmpv1;
	
	// look for a suitable starting point to start matching in the template.
	// if there is no such point we assume the template fits. however, the template
	// could match since it is too small (for exaple, the template for glycine will
	// match for all residues). therefore we have to test all templates and choose
	// the biggest matching one!!!
	
	i32u index = 0;
	while (index < tdata.size())
	{
		if (tdata[index].ref != NULL)
		{
			tmpv1.resize(0);
			for (i32u n1 = 0;n1 < tdata.size();n1++)
			{
				bool test1 = (tdata[n1].ref == NULL);
				bool test2 = (tdata[n1].id[1] == tdata[index].id[0]);
				if (test1 && test2) tmpv1.push_back(n1);
			}
			
			if (tmpv1.size()) break;
		}
		
		index++;
	}
	
	// if there is no suitable starting point, we have tested all atoms and
	// none of them is missing -> template fits -> TRUE!!!
	
	if (index == tdata.size()) return true;
	
	// find all possible bonds that we can use to continue testing...
	
	vector<crec> tmpv2; iter_cl it1;
	for (it1 = tdata[index].ref->GetConnRecsBegin();it1 != tdata[index].ref->GetConnRecsEnd();it1++)
	{
		bool test1 = (* it1).bndr->flags[flag];
		if (!test1) tmpv2.push_back((* it1));
	}
	
	// if there are less bonds than we need, the template can't match -> FALSE!!!
	
	if (tmpv2.size() < tmpv1.size()) return false;
	
	vector<i32s> tmpv3; tmpv3.resize(tmpv2.size());
	for (i32u n1 = 0;n1 < tmpv3.size();n1++) tmpv3[n1] = n1;
	
	// then we will check all bonds against the template in all possible permutations.
	// if some combination is a match then leave the ID-numbers untouched, clean the
	// bond flags and leave -> TRUE!!!
	
	while (true)
	{
		bool test = true;
		for (i32u n1 = 0;n1 < tmpv1.size();n1++)
		{
			i32s el = tdata[tmpv1[n1]].el.GetAtomicNumber();
			if (el != NOT_DEFINED && el != tmpv2[tmpv3[n1]].atmr->el.GetAtomicNumber()) test = false;
			
			i32s bt = tdata[tmpv1[n1]].bt.GetValue();
			if (bt != NOT_DEFINED && bt != tmpv2[tmpv3[n1]].bndr->bt.GetValue()) test = false;
		}
		
		if (test)
		{
			for (i32u n1 = 0;n1 < tmpv1.size();n1++)
			{
				tmpv2[tmpv3[n1]].bndr->flags[flag] = true;
				tdata[tmpv1[n1]].ref = tmpv2[tmpv3[n1]].atmr;
			}
			
			bool result = CheckTemplate(tdata, flag);
			
			for (i32u n1 = 0;n1 < tmpv1.size();n1++)
			{
				tmpv2[tmpv3[n1]].bndr->flags[flag] = false;
				if (!result) tdata[tmpv1[n1]].ref = NULL;
			}
			
			if (result) return true;
		}
		
		if (!next_permutation(tmpv3.begin(), tmpv3.end())) break;
	}
	
	// none of those combinations matched -> the template doesn't fit -> FALSE!!!
	
	return false;
}

/*################################################################################################*/

mf_data_atm::mf_data_atm(void)
{
	tr = NULL;
}

mf_data_atm::mf_data_atm(const mf_data_atm & p1)
{
	id = p1.id;
	
	el = p1.el;
	bt = p1.bt;
	
	ic2 = p1.ic2;
	
	for (i32s n1 = 0;n1 < 3;n1++)
	{
		prev[n1] = p1.prev[n1];
		ic1[n1] = p1.ic1[n1];
	}
	
	if (p1.tr != NULL) tr = new typerule(* p1.tr);
	else tr = NULL;
}

mf_data_atm::~mf_data_atm(void)
{
	if (tr != NULL) delete tr;
}

istream & operator>>(istream & p1, mf_data_atm & p2)
{
	char buffer[256];
	while (p1.get() != 'M');
	p1 >> p2.id; while (p1.get() != ':');
	p1 >> buffer; p2.el = element(buffer);
	p1 >> p2.prev[0] >> p2.prev[1] >> p2.prev[2];
	p1 >> p2.ic1[0] >> p2.ic1[1] >> p2.ic2 >> p2.ic1[2];
	
	p2.ic1[1] = M_PI * p2.ic1[1] / 180.0;
	p2.ic1[2] = M_PI * p2.ic1[2] / 180.0;
	
	p1 >> buffer;
	p2.bt = bondtype(buffer[0]);
	
//////////////////////////////////////////////////////////////////////////////////////////
if (p2.bt.GetValue() == 0) { cout << "bad bondtype A" << endl; exit(-1); }
//////////////////////////////////////////////////////////////////////////////////////////
	
	return p1;
}

ostream & operator<<(ostream & p1, mf_data_atm & p2)
{
	p1 << hex << "0x" << setw(4) << setfill('0') << p2.id << dec;
	p1 << " " << p2.el.GetSymbol() << " " << p2.bt.GetSymbol1();
	if (p2.tr != NULL) p1 << " " << (* p2.tr); p1 << " ";
	
	p1 << p2.ic1[0] << " " << p2.ic1[1] << " " << p2.ic2 << " " << p2.ic1[2] << " ";
	p1 << hex << "0x" << setw(4) << setfill('0') << p2.prev[0] << dec << " ";
	p1 << hex << "0x" << setw(4) << setfill('0') << p2.prev[1] << dec << " ";
	p1 << hex << "0x" << setw(4) << setfill('0') << p2.prev[2] << dec;
	
	return p1;
}

/*################################################################################################*/

mf_data_bnd::mf_data_bnd(void)
{
}

mf_data_bnd::~mf_data_bnd(void)
{
}

istream & operator>>(istream & p1, mf_data_bnd & p2)
{
	char buffer[256];
	while (p1.get() != ':');
	p1 >> p2.atm[0] >> p2.atm[1];
	p1 >> buffer; p2.bt = bondtype(buffer[0]);
	
//////////////////////////////////////////////////////////////////////////////////////////
if (p2.bt.GetValue() == 0) { cout << "bad bondtype B" << endl; exit(-1); }
//////////////////////////////////////////////////////////////////////////////////////////
	
	return p1;
}

/*################################################################################################*/

// eof
