/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * @author Ismael Juma <ismael@juma.me.uk>
 */

import org.gnu.glib.EventType;
import org.gnu.gtk.SelectionData;

public class RequestDragDataEvent extends DragEvent {
    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        public static Type DATA_REQUEST = new Type(0, "DATA_REQUEST");
    }

    private final SelectionData data;

    private final int targetInfo;

    private final int time;

    public RequestDragDataEvent(DragEvent event, SelectionData data,
            int targetInfo, int time) {
        super(event);
        this.data = data;
        this.targetInfo = targetInfo;
        this.time = time;
    }

    public SelectionData getSelectionData() {
        return data;
    }

    public int getTargetInfo() {
        return targetInfo;
    }

    public int getTime() {
        return time;
    }

}
