/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: AboutCommand.java,v 1.7 2004/12/12 05:29:28 pietschy Exp $
 */
package org.pietschy.command.demo.about;

import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;
import org.pietschy.command.demo.Demo;
import org.pietschy.command.demo.DemoFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: andrewp
 * Date: 12/04/2004
 * Time: 13:16:22
 * To change this template use Options | File Templates.
 */
public class
AboutCommand
extends ActionCommand
{
   public static final String ID = "menu.help.about";
   private JDialog dialog;

   public AboutCommand(CommandManager cm, String id)
   {
      super(cm, id);
   }

   protected void
   handleExecute()
   {
      DemoFrame owner = Demo.instance().getMainFrame();

      if (dialog == null)
         buildDialog(owner);

      dialog.setLocationRelativeTo(owner);
      dialog.setVisible(true);
   }

   private void
   buildDialog(DemoFrame owner)
   {
      HTMLPane message = new HTMLPane();
      try
      {
         message.setPage(getClass().getResource("about.html"));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load welcome.html", e);
      }

      dialog = new JDialog(owner, "About", true);
      message.setPreferredSize(new Dimension(300,100));
      dialog.getContentPane().add(message);
      dialog.pack();

      message.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "close");
      message.getActionMap().put("close", new AbstractAction(){
         public void actionPerformed(ActionEvent e)
         {
            dialog.setVisible(false);
         }
      });
   }
}
