%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%define dist redhat
%define disttag rh

%if %is_mandrake
%define dist mandrake
%define disttag mdk
%endif
%if %is_suse
%define dist suse
%define disttag suse
%endif
%if %is_fedora
%define dist fedora
%define disttag rhfc
%endif

%define distver %(release="`rpm -q --queryformat='%{VERSION}' %{dist}-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; echo "$release")

Summary: A multi-platform helper library for other libraries
Name: gwenhywfar
Version: 1.18.0
Release: 1.%{disttag}%{distver}
Source: http://download.sourceforge.net/gwenhywfar/%{name}-%{version}.tar.gz
Group: System Environment/Libraries
License: LGPL
Packager: Martin Preuss <martin@libchipcard.de>
URL: http://sourceforge.net/projects/gwenhywfar
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: openssl-devel ncurses-devel gettext
Prereq: /sbin/ldconfig

%description
This is Gwenhywfar, a multi-platform helper library for networking and
security applications and libraries. It is heavily used by libchipcard
www.libchipcard.de and AqBanking/AqHBCI, the German online banking 
libraries.

%package devel
Summary: Gwenhywfar development kit
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
%description devel
This package contains gwenhywfar-config and header files for writing and
compiling programs using Gwenhywfar.


%prep
%setup -q

%build
%configure --disable-static
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root)
%doc AUTHORS README COPYING ChangeLog
%{_libdir}/*.so.*
%{_libdir}/*.so
%{_libdir}/%{name}
%{_datadir}/locale/*/LC_MESSAGES/gwenhywfar.mo
%{_bindir}/gct-tool
%{_sysconfdir}/*.crt

%files devel
%defattr(-,root,root)
%{_bindir}/gwenhywfar-config
%{_bindir}/xmlmerge
%{_bindir}/dlgtest
%{_bindir}/mklistdoc
%{_bindir}/typemaker
%{_includedir}/gwenhywfar
%{_includedir}/gwenpp
%{_libdir}/*.la
#%{_libdir}/*.a
%{_datadir}/aclocal/gwenhywfar.m4

%changelog
