/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: nl_packets_p.h 1108 2007-01-09 14:52:56Z christian $
    begin       : Sat Jan 24 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef GWEN_NL_PACKETS_P_H
#define GWEN_NL_PACKETS_P_H


#define GWEN_NL_PACKETS_CHUNKSIZE 512

#include "nl_packets.h"

GWEN_LIST_FUNCTION_DEFS(GWEN_NL_PACKET, GWEN_NL_Packet)

#include <gwenhywfar/buffer.h>



struct GWEN_NL_PACKET {
  GWEN_INHERIT_ELEMENT(GWEN_NL_PACKET)
  GWEN_LIST_ELEMENT(GWEN_NL_PACKET)

  GWEN_NL_PACKET_STATUS status;
  GWEN_BUFFER *buffer;
  int usage;
};


typedef struct GWEN_NL_PACKETS GWEN_NL_PACKETS;
struct GWEN_NL_PACKETS {
  GWEN_NL_PACKET_LIST *outPackets;
  GWEN_NL_PACKET *currentOutPacket;
  GWEN_NL_PACKET_LIST *inPackets;
  GWEN_NL_PACKET *currentInPacket;
  unsigned int fixedPacketSize;
};

void GWENHYWFAR_CB GWEN_NetLayerPackets_FreeData(void *bp, void *p);

int GWEN_NetLayerPackets_Connect(GWEN_NETLAYER *nl);
int GWEN_NetLayerPackets_Disconnect(GWEN_NETLAYER *nl);
int GWEN_NetLayerPackets_Listen(GWEN_NETLAYER *nl);

int GWEN_NetLayerPackets_AddSockets(GWEN_NETLAYER *nl,
                                    GWEN_SOCKETSET *readSet,
                                    GWEN_SOCKETSET *writeSet,
                                    GWEN_SOCKETSET *exSet);


GWEN_NETLAYER_RESULT GWEN_NetLayerPackets_Work(GWEN_NETLAYER *nl);

GWEN_NETLAYER_RESULT GWEN_NetLayerPackets__WriteWork(GWEN_NETLAYER *nl);
GWEN_NETLAYER_RESULT GWEN_NetLayerPackets__ReadWork(GWEN_NETLAYER *nl);


#endif /* GWEN_NL_PACKETS_P_H */


