#!/bin/bash

set -e

cd "$(dirname "$0")" || exit 1

urls=(
    https://download.fcitx-im.org/data/lm_sc.3gm.arpa-20140820.tar.bz2
    https://download.fcitx-im.org/data/dict.utf8-20200715.tar.xz
    https://download.fcitx-im.org/data/table.tar.gz
)

checksums () {
    echo 751bab7c55ea93a2cedfb0fbb7eb09f67d4da9c2c55496e5f31eb8580f1d1e2f lm_sc.3gm.arpa-20140820.tar.bz2
    echo 23c36cd4df6de17f66bf2dfc453ec6c773641a479b6020c9e787552489c9c7d2 dict.utf8-20200715.tar.xz
    echo 6196053c724125e3ae3d8bd6b2f9172d0c83b65b0d410d3cde63b7a8d6ab87b7 table.tar.gz
}

for url in "${urls[@]}"; do
    curl -O "$url"
done

checksums | sha256sum --check

for url in "${urls[@]}"; do
    filename="${url##*/}"
    tar xf "$filename"
    rm -f "$filename"
done
