#!/bin/bash

set -ex

cd "$(dirname "$0")" || exit 1
commit=96d303cfb1a0c21b8f060dbad640d7ab301c019a
tarball=https://github.com/kpu/kenlm/archive/"$commit".tar.gz
rm -rf kenlm
mkdir -p kenlm
curl -o- -L "$tarball" | \
    tar -C kenlm/ --strip-components=1 -x -z --wildcards --no-wildcards-match-slash \
    --exclude='util/getopt.*' \
    '*/lm/*.cc' '*/lm/*.hh' '*/util/*.hh' '*/util/*.cc'

patch -p3 < ./kenlm.patch
