/*
 * Copyright 2005 [ini4j] Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ini4j;

import java.beans.*;
import java.lang.reflect.*;
import java.util.prefs.*;
import java.util.*;

public class PreferencesBean
{
    public static <T> T newInstance(Class<T> clazz, final Preferences prefs)
    {
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[] {clazz}, new AbstractBeanInvocationHandler()
        {
            protected Object getPropertySpi(String property, Class<?> clazz)
            {
                return prefs.get(property,null);
            }
        
            protected void setPropertySpi(String property, Object value, Class<?> clazz)
            {
                prefs.put(property, value.toString());
            }
            
            protected boolean hasPropertySpi(String property)
            {
                return prefs.get(property, null) != null;
            }
        }
        ));
    }
}
