/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/


#include <cstdio>
#include <cstdlib>
#include <time.h>

#include <libinstrudeo/isdlogger.h>

ISDLogger* ISDLogger::instance = NULL;//init instance

//-----PUBLIC METHODS-----
ISDLogger* ISDLogger::getInstance()
{
    //create an instance if necessary
    if (instance==NULL){
	instance = new ISDLogger();
    }

    return instance;
}
void ISDLogger::log(logLevel level, string headerTitle, string message,
		    ostream& stream, logType type, string host, string program)
{
    time_t now = time(NULL);
    struct tm* timePtr = localtime(&now);
    int BUF_SIZE = 100;
    char strBuf[BUF_SIZE];
    
    //time format: Jun 21 11:53:01

    //note: buffer is only used for the date-part (security reasons)
    strftime(strBuf, BUF_SIZE, "%b %e %H:%M:%S", timePtr);

    //default action: write out to stdout
    if (loggingEnabled && level<=currentLevel) {
	switch (level) {
	    case ISD_LOG_LEVEL_INFO:
		switch (type) {
		case ISD_LOG_TYPE_FANCY:
		    stream << "----------" << headerTitle << " INFO LOG ENTRY----------" << endl;
		    stream << "--> " << strBuf << " <--" << endl;
		    stream << message << endl;    
		    stream << "---------------------------------------------" << endl;
		    break;
		case ISD_LOG_TYPE_SYSLOG:
		    stream << strBuf << " " << host << " " << program << ": [INFO] " << message << endl;
		    break;
		}
		break;
	    case ISD_LOG_LEVEL_WARNING:
		switch (type) {
		case ISD_LOG_TYPE_FANCY:
		    stream << "----------" << headerTitle << " WARNING LOG ENTRY----------" << endl;
		    stream << "--> " << strBuf << " <--" << endl;
		    stream << message << endl;    
		    stream << "---------------------------------------------" << endl;
		    break;
		case ISD_LOG_TYPE_SYSLOG:
		    stream << strBuf << " " << host << " " << program << ": [WARNING] " << message << endl;
		    break;
		}
		break;
	    case ISD_LOG_LEVEL_CRITICAL:
		switch (type) {
		case ISD_LOG_TYPE_FANCY:
		    stream << "----------" << headerTitle << " CRITICAL LOG ENTRY----------" << endl;
		    stream << "--> " << strBuf << " <--" << endl;
		    stream << message << endl;    
		    stream << "---------------------------------------------" << endl;
		    break;
		case ISD_LOG_TYPE_SYSLOG:
		    stream << strBuf << " " << host << " " << program << ": [CRITICAL] " << message << endl;
		    break;
		}
		break;
	}
    }
}
void ISDLogger::setLevel(logLevel level)
{
    this->currentLevel = level;
}
ISDLogger::logLevel ISDLogger::getLevel()
{
    return currentLevel;
}

//-----(PRIVATE) CONSTRUCTORS-----
ISDLogger::ISDLogger()
    : ISDObject(),
      currentLevel(ISD_LOG_LEVEL_CRITICAL),
      loggingEnabled(true)
{
}


