#include "toolbar.h"
#include <inti/gtk/entry.h>
#include <inti/gtk/handlebox.h>
#include <inti/bind.h>

ToolbarDialog::ToolbarDialog()
{
	set_title("Gtk::Toolbar Tutorial");
	set_size_request(600, 300);
	set_resizable(true);

	// To make it nice we'll put the toolbar into the handle box so it can be detached from the main window.
	Gtk::HandleBox *handlebox = new Gtk::HandleBox;
	client_area()->pack_start(*handlebox, false, false, 5);

	// The toolbar will be horizontal, with both icons and text, and we'll also pack it into our handlebox.
	toolbar = new Gtk::Toolbar(Gtk::ORIENTATION_HORIZONTAL, Gtk::TOOLBAR_BOTH);
	handlebox->add(*toolbar);

	// We need an icon with a mask (one for each button) and an image widget to put the icon in,
	// so we'll create a separate image widget for each button).
	Gtk::Image *image = new Gtk::Image("gtk.xpm");

	// Create our first button, a "close" button. To destroy any widget/window in response to a button click
	// just create a slot using the inherited dispose method and connect it to the button. Here, Gtk::Toolbar
	// does the connection stuff for us, we just supply the slot.
	toolbar->append_button("Close", image, slot(this, &ToolbarDialog::dispose), "Closes this app");

	// Append a space after the close button.
	toolbar->append_space();

	// Now, let's make our radio button group. Note, rather than set up a separate method to change
	// the toolbar style we use "bind" to bind the toolbar style each radio button respresents directly
	// to Gtk::Toolbar::set_style() method.
	image = new Gtk::Image("gtk.xpm");
	Gtk::RadioButton *group = toolbar->append_radio_button(0, "Icon", image,
	                                                       bind(slot(toolbar, &Gtk::Toolbar::set_style), Gtk::TOOLBAR_ICONS), 
														   "Only icons in toolbar");
	toolbar->append_space();

	// The following radio buttons refer to previous one as the group
	image = new Gtk::Image("gtk.xpm");
	toolbar->append_radio_button(group, "Text", image, 
	                             bind(slot(toolbar, &Gtk::Toolbar::set_style), Gtk::TOOLBAR_TEXT),
	                             "Only texts in toolbar");
	toolbar->append_space();

	image = new Gtk::Image("gtk.xpm");
	group = toolbar->append_radio_button(group, "Both", image, 
	                                     bind(slot(toolbar, &Gtk::Toolbar::set_style), Gtk::TOOLBAR_BOTH), 
										 "Icons and texts in toolbar");
	group->set_active(true);
	toolbar->append_space();

	// Here we have just a simple toggle button. The on_toggle_button() method just checks 
	// the toggle button's active state and enabless/disables the tooltips accordingly.
	image = new Gtk::Image("gtk.xpm");
	toggle_button = toolbar->append_toggle_button("Tooltips", image, slot(this, &ToolbarDialog::on_toggle_button),
	                                              "Toolbar with or without tips");
	toolbar->append_space();
	toggle_button->set_active(true);

	// Now we pack a widget into toolbar, we only have to create it and append it with an appropriate tooltip.
	Gtk::Entry *entry = new Gtk::Entry;
	toolbar->append_widget(*entry, "This is just an entry");

	// The Entry isn't created within the toolbar, so we must still show it.
	entry->show();

	// That's it ! let's show everything.
	toolbar->show();
	handlebox->show();
}

ToolbarDialog::~ToolbarDialog()
{
}

void 
ToolbarDialog::on_toggle_button() 
{ 
	toolbar->set_tooltips(toggle_button->get_active()); 
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	ToolbarDialog dialog;
	dialog.sig_destroy().connect(slot(&Inti::Main::quit));
	dialog.show();

	run();
	return 0;
}
