/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  editabletext.cc - AtkEditableText C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "editabletext.h"
#include "private/editabletext_p.h"
#include "../glib/object.h"

using namespace Inti;

/*  Atk::EditableText
 */

Atk::EditableText::~EditableText()
{
}
	
AtkEditableTextIface* 
Atk::EditableText::atk_editable_text_iface() const 
{ 
	return peek<AtkEditableTextIface>(ATK_TYPE_EDITABLE_TEXT); 
}
	
Atk::EditableText::operator AtkEditableText* () const 
{ 
	return this ? atk_editable_text() : 0;
}
	
bool
Atk::EditableText::set_run_attributes(const std::vector<Attribute>& attribs, int start_offset, int end_offset)
{
	g_return_val_if_fail(!attribs.empty(), false);

	GSList *tmp_attribs = 0;
	int count = attribs.size();

	int i = 0;
	while (i < count)
	{
		tmp_attribs = g_slist_append(tmp_attribs, attribs[i].atk_attribute());
		++i;
	}
	bool result = atk_editable_text_set_run_attributes(atk_editable_text(), tmp_attribs, start_offset, end_offset);
	g_slist_free(tmp_attribs);
	return result;
}

void
Atk::EditableText::set_text_contents(const String& str)
{
	atk_editable_text_set_text_contents(atk_editable_text(), str.c_str());
}

void
Atk::EditableText::insert_text(const String& str, int *position)
{
	atk_editable_text_insert_text(atk_editable_text(), str.c_str(), str.size(), position);
}

void 
Atk::EditableText::copy_text(int start_pos, int end_pos)
{
	atk_editable_text_copy_text(atk_editable_text(), start_pos, end_pos);
}

void 
Atk::EditableText::cut_text(int start_pos, int end_pos)
{
	atk_editable_text_cut_text(atk_editable_text(), start_pos, end_pos);
}

void 
Atk::EditableText::delete_text(int start_pos, int end_pos)
{
	atk_editable_text_delete_text(atk_editable_text(), start_pos, end_pos);
}

void
Atk::EditableText::paste_text(int position)
{
	atk_editable_text_paste_text(atk_editable_text(), position);
}

/*  Atk::EditableTextIface
 */

void
Atk::EditableTextIface::init(AtkEditableTextIface *g_iface)
{
	g_iface->set_run_attributes = &set_run_attributes_proxy;
	g_iface->set_text_contents = &set_text_contents_proxy;
	g_iface->insert_text = &insert_text_proxy;
	g_iface->copy_text = &copy_text_proxy;
	g_iface->cut_text = &cut_text_proxy;
	g_iface->delete_text = &delete_text_proxy;
	g_iface->paste_text = &paste_text_proxy;
}

gboolean
Atk::EditableTextIface::set_run_attributes_proxy(AtkEditableText *text, AtkAttributeSet *attrib_set, gint start_offset, gint end_offset)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(text));
	Atk::EditableText *tmp_text = dynamic_cast<Atk::EditableText*>(object);
	if (tmp_text)
		result = tmp_text->do_set_run_attributes(attrib_set, start_offset, end_offset);
	else
	{
		AtkEditableTextIface *tmp_iface = ATK_EDITABLE_TEXT_GET_IFACE(text);
		AtkEditableTextIface *g_iface = static_cast<AtkEditableTextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->set_run_attributes)
			result = g_iface->set_run_attributes(text, attrib_set, start_offset, end_offset);
	}
	return result;
}

void
Atk::EditableTextIface::set_text_contents_proxy(AtkEditableText *text, const gchar *string)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(text));
	Atk::EditableText *tmp_text = dynamic_cast<Atk::EditableText*>(object);
	if (tmp_text)
		tmp_text->do_set_text_contents(string);
	else
	{
		AtkEditableTextIface *tmp_iface = ATK_EDITABLE_TEXT_GET_IFACE(text);
		AtkEditableTextIface *g_iface = static_cast<AtkEditableTextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->set_text_contents)
			g_iface->set_text_contents(text, string);
	}
}

void
Atk::EditableTextIface::insert_text_proxy(AtkEditableText *text, const gchar *string, gint length, gint *position)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(text));
	Atk::EditableText *tmp_text = dynamic_cast<Atk::EditableText*>(object);
	if (tmp_text)
		tmp_text->do_insert_text(string, length, position);
	else
	{
		AtkEditableTextIface *tmp_iface = ATK_EDITABLE_TEXT_GET_IFACE(text);
		AtkEditableTextIface *g_iface = static_cast<AtkEditableTextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->insert_text)
			g_iface->insert_text(text, string, length, position);
	}
}

void
Atk::EditableTextIface::copy_text_proxy(AtkEditableText *text, gint start_pos, gint end_pos)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(text));
	Atk::EditableText *tmp_text = dynamic_cast<Atk::EditableText*>(object);
	if (tmp_text)
		tmp_text->do_copy_text(start_pos, end_pos);
	else
	{
		AtkEditableTextIface *tmp_iface = ATK_EDITABLE_TEXT_GET_IFACE(text);
		AtkEditableTextIface *g_iface = static_cast<AtkEditableTextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->copy_text)
			g_iface->copy_text(text, start_pos, end_pos);
	}
}

void
Atk::EditableTextIface::cut_text_proxy(AtkEditableText *text, gint start_pos, gint end_pos)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(text));
	Atk::EditableText *tmp_text = dynamic_cast<Atk::EditableText*>(object);
	if (tmp_text)
		tmp_text->do_cut_text(start_pos, end_pos);
	else
	{
		AtkEditableTextIface *tmp_iface = ATK_EDITABLE_TEXT_GET_IFACE(text);
		AtkEditableTextIface *g_iface = static_cast<AtkEditableTextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->cut_text)
			g_iface->cut_text(text, start_pos, end_pos);
	}
}

void
Atk::EditableTextIface::delete_text_proxy(AtkEditableText *text, gint start_pos, gint end_pos)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(text));
	Atk::EditableText *tmp_text = dynamic_cast<Atk::EditableText*>(object);
	if (tmp_text)
		tmp_text->do_delete_text(start_pos, end_pos);
	else
	{
		AtkEditableTextIface *tmp_iface = ATK_EDITABLE_TEXT_GET_IFACE(text);
		AtkEditableTextIface *g_iface = static_cast<AtkEditableTextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->delete_text)
			g_iface->delete_text(text, start_pos, end_pos);
	}
}

void
Atk::EditableTextIface::paste_text_proxy(AtkEditableText *text, gint position)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(text));
	Atk::EditableText *tmp_text = dynamic_cast<Atk::EditableText*>(object);
	if (tmp_text)
		tmp_text->do_paste_text(position);
	else
	{
		AtkEditableTextIface *tmp_iface = ATK_EDITABLE_TEXT_GET_IFACE(text);
		AtkEditableTextIface *g_iface = static_cast<AtkEditableTextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->paste_text)
			g_iface->paste_text(text, position);
	}
}

/*  Overridable methods
 */

bool
Atk::EditableText::do_set_run_attributes(AtkAttributeSet *attrib_set, int start_offset, int end_offset)
{
	bool result = false;
	AtkEditableTextIface *g_iface = peek_parent<AtkEditableTextIface>(atk_editable_text_iface());
	if (g_iface->set_run_attributes)
		result = g_iface->set_run_attributes(atk_editable_text(), attrib_set, start_offset, end_offset);
	return result;
}

void
Atk::EditableText::do_set_text_contents(const char *string)
{
	AtkEditableTextIface *g_iface = peek_parent<AtkEditableTextIface>(atk_editable_text_iface());
	if (g_iface->set_text_contents)
		g_iface->set_text_contents(atk_editable_text(), string);
}

void
Atk::EditableText::do_insert_text(const char *string, int length, int *position)
{
	AtkEditableTextIface *g_iface = peek_parent<AtkEditableTextIface>(atk_editable_text_iface());
	if (g_iface->insert_text)
		g_iface->insert_text(atk_editable_text(), string, length, position);
}

void
Atk::EditableText::do_copy_text(int start_pos, int end_pos)
{
	AtkEditableTextIface *g_iface = peek_parent<AtkEditableTextIface>(atk_editable_text_iface());
	if (g_iface->copy_text)
		g_iface->copy_text(atk_editable_text(), start_pos, end_pos);
}

void
Atk::EditableText::do_cut_text(int start_pos, int end_pos)
{
	AtkEditableTextIface *g_iface = peek_parent<AtkEditableTextIface>(atk_editable_text_iface());
	if (g_iface->cut_text)
		g_iface->cut_text(atk_editable_text(), start_pos, end_pos);
}

void
Atk::EditableText::do_delete_text(int start_pos, int end_pos)
{
	AtkEditableTextIface *g_iface = peek_parent<AtkEditableTextIface>(atk_editable_text_iface());
	if (g_iface->delete_text)
		g_iface->delete_text(atk_editable_text(), start_pos, end_pos);
}

void
Atk::EditableText::do_paste_text(int position)
{
	AtkEditableTextIface *g_iface = peek_parent<AtkEditableTextIface>(atk_editable_text_iface());
	if (g_iface->paste_text)
		g_iface->paste_text(atk_editable_text(), position);
}

