/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  table_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_TABLE_IFACE_H
#define INTI_ATK_TABLE_IFACE_H

namespace Inti {

namespace Atk {

class TableIface
{
public:
	static void init(AtkTableIface *g_iface);

// Methods
	static AtkObject* ref_at_proxy(AtkTable *table, gint row, gint column);

	static gint get_index_at_proxy(AtkTable *table, gint row, gint column);

	static gint get_column_at_index_proxy(AtkTable *table, gint index);

	static gint get_row_at_index_proxy(AtkTable *table, gint index);

	static gint get_n_columns_proxy(AtkTable *table);

	static gint get_n_rows_proxy(AtkTable *table);

	static gint get_column_extent_at_proxy(AtkTable *table, gint row, gint column);

	static gint get_row_extent_at_proxy(AtkTable *table, gint row, gint column);

	static AtkObject* get_caption_proxy(AtkTable *table);

	static const gchar* get_column_description_proxy(AtkTable *table, gint column);

	static AtkObject* get_column_header_proxy(AtkTable *table, gint column);

	static const gchar* get_row_description_proxy(AtkTable *table, gint row);

	static AtkObject* get_row_header_proxy(AtkTable *table, gint row);

	static AtkObject* get_summary_proxy(AtkTable *table);

	static void set_caption_proxy(AtkTable *table, AtkObject *caption);

	static void set_column_description_proxy(AtkTable *table, gint column, const gchar *description);

	static void set_column_header_proxy(AtkTable *table, gint column, AtkObject *header);

	static void set_row_description_proxy(AtkTable *table, gint row, const gchar *description);

	static void set_row_header_proxy(AtkTable *table, gint row, AtkObject *header);

	static void set_summary_proxy(AtkTable *table, AtkObject *accessible);

	static gint get_selected_columns_proxy(AtkTable *table, gint **selected);

	static gint get_selected_rows_proxy(AtkTable *table, gint **selected);

	static gboolean is_column_selected_proxy(AtkTable *table, gint column);

	static gboolean is_row_selected_proxy(AtkTable *table, gint row);

	static gboolean is_selected_proxy(AtkTable *table, gint row, gint column);

	static gboolean add_row_selection_proxy(AtkTable *table, gint row);

	static gboolean remove_row_selection_proxy(AtkTable *table, gint row);

	static gboolean add_column_selection_proxy(AtkTable *table, gint column);

	static gboolean remove_column_selection_proxy(AtkTable *table, gint column);
	
// Signals
	static void row_inserted_proxy(AtkTable *table, gint row, gint num_inserted);

	static void column_inserted_proxy(AtkTable *table, gint column, gint num_inserted);

	static void row_deleted_proxy(AtkTable *table, gint row, gint num_deleted);

	static void column_deleted_proxy(AtkTable *table, gint column, gint num_deleted);

	static void row_reordered_proxy(AtkTable *table);

	static void column_reordered_proxy(AtkTable *table);

	static void model_changed_proxy(AtkTable *table);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_TABLE_IFACE_H
