/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  stateset.cc - AtkStateSet C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "stateset.h"
#include "private/stateset_p.h"

using namespace Inti;

/*  Atk::state_type_register
 */

Atk::StateType
Atk::state_type_register(const String& name)
{
	return (StateType)atk_state_type_register(name.c_str());
}

/*  Atk::state_type_get_name
 */

String
Atk::state_type_get_name(StateType type)
{
	return atk_state_type_get_name((AtkStateType)type);
}

/*  Atk::state_type_for_name
 */

Atk::StateType
Atk::state_type_for_name(const String& name)
{
	return (StateType)atk_state_type_for_name(name.c_str());
}

/*  Atk::StateSet
 */

Atk::StateSet::StateSet(AtkStateSet *set, bool reference)
: G::Object((GObject*)set, reference)
{
}
	
Atk::StateSet::StateSet()
: G::Object((GObject*)StateSetClass::create())
{
}

Atk::StateSet::~StateSet()
{
}
	
AtkStateSetClass* 
Atk::StateSet::atk_state_set_class() const 
{ 
	return get_class<AtkStateSetClass>(); 
}
	
Atk::StateSet::operator AtkStateSet* () const 
{ 
	return this ? atk_state_set() : 0; 
}
	
bool 
Atk::StateSet::is_empty() const
{
	return atk_state_set_is_empty(atk_state_set());
}

bool
Atk::StateSet::contains_state(StateType type) const
{
	return atk_state_set_contains_state(atk_state_set(), (AtkStateType)type);
}

bool 
Atk::StateSet::contains_states(const std::vector<StateType>& types) const
{
	AtkStateType *tmp_types = reinterpret_cast<AtkStateType*>(const_cast<StateType*>(&types[0]));
	return atk_state_set_contains_states(atk_state_set(), tmp_types, types.size());
}

bool
Atk::StateSet::add_state(StateType type)
{
	return atk_state_set_add_state(atk_state_set(), (AtkStateType)type);
}

void
Atk::StateSet::add_states(const std::vector<StateType>& types)
{
	AtkStateType *tmp_types = reinterpret_cast<AtkStateType*>(const_cast<StateType*>(&types[0]));
	atk_state_set_add_states(atk_state_set(), tmp_types, types.size());
}

void 
Atk::StateSet::clear_states()
{
	atk_state_set_clear_states(atk_state_set());
}

bool 
Atk::StateSet::remove_state(StateType type)
{
	return atk_state_set_remove_state(atk_state_set(), (AtkStateType)type);
}

Pointer<Atk::StateSet> 
Atk::StateSet::and_sets(StateSet& compare_set)
{
	AtkStateSet *set = atk_state_set_and_sets(atk_state_set(), compare_set.atk_state_set());
	return set ? G::Object::wrap_new<StateSet>(set, true) : 0;
}

Pointer<Atk::StateSet> 
Atk::StateSet::or_sets(StateSet& compare_set)
{
	AtkStateSet *set = atk_state_set_or_sets(atk_state_set(), compare_set.atk_state_set());
	return set ? G::Object::wrap_new<StateSet>(set, true) : 0;
}

Pointer<Atk::StateSet> 
Atk::StateSet::xor_sets(StateSet& compare_set)
{
	AtkStateSet *set = atk_state_set_xor_sets(atk_state_set(), compare_set.atk_state_set());
	return set ? G::Object::wrap_new<StateSet>(set, true) : 0;
}

/*  Atk::StateSetClass
 */

void
Atk::StateSetClass::init(AtkStateSetClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Atk::StateSetClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_STATE_SET, (GClassInitFunc)init);
	}
	return type;
}

void*
Atk::StateSetClass::create()
{
	return g_object_new(get_type(), 0);
}

