/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  events.cc - Gdk events C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "events.h"
#include "display.h"
#include "dnd.h"
#include "keyval.h"
#include "input.h"
#include "region.h"
#include "screen.h"
#include "window.h"

using namespace Inti;

/*  Gdk::get_show_events
 */

bool
Gdk::get_show_events()
{
	return gdk_get_show_events();
}

/*  Gdk::events_pending
 */
bool
Gdk::events_pending()
{
	return gdk_events_pending();
}

/*  Gdk::set_show_events
 */
void
Gdk::set_show_events(bool show_events)
{
	gdk_set_show_events(show_events);
}

/*  Gdk::Event
 */

Gdk::Event::Event()
: G::Boxed(GDK_TYPE_EVENT)
{
}

Gdk::Event::Event(EventType type)
: G::Boxed(GDK_TYPE_EVENT, gdk_event_new((GdkEventType)type), false)
{
}

Gdk::Event::Event(GdkEvent* event)
: G::Boxed(GDK_TYPE_EVENT, event)
{
}

Gdk::Event::Event(GdkEvent* event, bool copy)
: G::Boxed(GDK_TYPE_EVENT, event, copy)
{
}

Gdk::Event::Event(const Event& src)
: G::Boxed(GDK_TYPE_EVENT, src.g_boxed(), true)
{
}

Gdk::Event::~Event()
{
}

Gdk::Event& 
Gdk::Event::operator=(const Event& src)
{
	if (src.boxed_ != boxed_)
		copy(src);
	return *this;
}

Gdk::Event::operator GdkEvent* () const
{
	return this ? gdk_event() : 0;
}

Gdk::EventType
Gdk::Event::type() const
{
	return (EventType)gdk_event()->type;
}

Gdk::EventAny*
Gdk::Event::any() const
{
	return (EventAny*)gdk_event();
}

Gdk::EventExpose*
Gdk::Event::expose() const
{
	return type() == EXPOSE ? (EventExpose*)this : 0;
}

Gdk::EventVisibility*
Gdk::Event::visibility() const
{
	return type() == VISIBILITY_NOTIFY ? (EventVisibility*)this : 0;
}
	
Gdk::EventMotion*
Gdk::Event::motion() const
{
	return type() == MOTION_NOTIFY ? (EventMotion*)this : 0;
}

Gdk::EventButton*
Gdk::Event::button() const
{
	bool is_type = type() == BUTTON_PRESS || type() == TWO_BUTTON_PRESS || 
	               type() == THREE_BUTTON_PRESS || type() == BUTTON_RELEASE;
	return is_type ? (EventButton*)this : 0;
}
	
Gdk::EventScroll*
Gdk::Event::scroll() const
{
	return type() == SCROLL ? (EventScroll*)this : 0;
}

Gdk::EventKey*
Gdk::Event::key() const
{
	return (type() == KEY_PRESS || type() == KEY_RELEASE) ? (EventKey*)this : 0;
}
	
Gdk::EventCrossing*
Gdk::Event::crossing() const
{
	return (type() == ENTER_NOTIFY || type() == LEAVE_NOTIFY) ? (EventCrossing*)this : 0;
}

Gdk::EventFocus*
Gdk::Event::focus_change() const
{
	return type() == FOCUS_CHANGE ? (EventFocus*)this : 0;
}

Gdk::EventConfigure*
Gdk::Event::configure() const
{
	return type() == CONFIGURE ? (EventConfigure*)this : 0;
}

Gdk::EventProperty*
Gdk::Event::property() const
{
	return type() == PROPERTY_NOTIFY ? (EventProperty*)this : 0;
}

Gdk::EventSelection*
Gdk::Event::selection() const
{
	bool is_type = type() == SELECTION_CLEAR || type() == SELECTION_REQUEST || type() == SELECTION_NOTIFY;
	return is_type ? (EventSelection*)this : 0;
}

Gdk::EventProximity*
Gdk::Event::proximity() const
{
	return (type() == PROXIMITY_IN || type() == PROXIMITY_OUT) ? (EventProximity*)this : 0;
}
	
Gdk::EventClient*
Gdk::Event::client() const
{
	return type() == CLIENT_EVENT ? (EventClient*)this : 0;
}
	
Gdk::EventSetting*
Gdk::Event::setting() const
{
	return type() == SETTING ? (EventSetting*)this : 0;
}

Gdk::EventWindowState*
Gdk::Event::window_state() const
{
	return type() == WINDOW_STATE ? (EventWindowState*)this : 0;
}

Gdk::EventDND*
Gdk::Event::dnd() const
{
	bool is_type = type() == DRAG_ENTER || type() == DRAG_LEAVE || type() == DRAG_MOTION ||
	               type() == DRAG_STATUS || type() == DROP_START || type() == DROP_FINISHED;
	return is_type ? (EventDND*)this : 0;
}

unsigned int
Gdk::Event::get_time() const
{
	return gdk_event_get_time(gdk_event());
}

bool
Gdk::Event::get_state(ModifierTypeField *state) const
{
	return gdk_event_get_state(gdk_event(), (GdkModifierType*)state) != 0;
}

bool 
Gdk::Event::get_axis(AxisUse axis_use, double *value) const
{
	return gdk_event_get_axis(gdk_event(), (GdkAxisUse)axis_use, value);
}

bool
Gdk::Event::get_coords(double *x_win, double *y_win) const
{
	return gdk_event_get_coords(gdk_event(), x_win, y_win) != 0;
}

bool
Gdk::Event::get_root_coords(double *x_root, double *y_root) const
{
	return gdk_event_get_root_coords(gdk_event(), x_root, y_root) != 0;
}

Gdk::Screen*
Gdk::Event::get_screen() const
{
	return G::Object::wrap<Screen>(gdk_event_get_screen(gdk_event()));
}

Pointer<Gdk::Event>
Gdk::Event::get()
{
	Event *event = 0;
	GdkEvent *gdk_event = gdk_event_get();
	if (gdk_event)
		event = new Event(gdk_event, false);
	return event;
}

Pointer<Gdk::EventExpose>
Gdk::Event::get_graphics_expose(const Window& window)
{
	Event *event = 0;
	GdkEvent *gdk_event = gdk_event_get_graphics_expose(window.gdk_window());
	if (gdk_event)
		event = new Event(gdk_event, false);
	return event ? event->expose() : 0;
}

Pointer<Gdk::Event>
Gdk::Event::peek()
{
	Event *event = 0;
	GdkEvent *gdk_event = gdk_event_peek();
	if (gdk_event)
		event = new Event(gdk_event, false);
	return event;
}

void
Gdk::Event::put()
{
	gdk_event_put(gdk_event());
}

bool
Gdk::Event::send_client_message(GdkNativeWindow winid, const Display *display)
{
	bool client_event = type() == CLIENT_EVENT;
	if (client_event)
	{
		GdkDisplay *tmp_display = display ? display->gdk_display() : gdk_display_get_default();
		client_event = gdk_event_send_client_message_for_display(tmp_display, gdk_event(), winid);
	}
	return client_event;
}

void 
Gdk::Event::send_clientmessage_toall()
{
	if (type() == CLIENT_EVENT)
		gdk_event_send_clientmessage_toall(gdk_event());
}

void 
Gdk::Event::set_screen(Screen& screen)
{
	gdk_event_set_screen(gdk_event(), screen.gdk_screen());
}

/*  Gdk::EventAny
 */

Gdk::Window*
Gdk::EventAny::window() const
{
	return G::Object::wrap<Window>(gdk_event_any()->window);
}

bool
Gdk::EventAny::send_event() const
{
	return gdk_event_any()->send_event;
}

/*  Gdk::EventExpose
 */

const Gdk::Rectangle&
Gdk::EventExpose::area() const
{
	return reinterpret_cast<Rectangle&>(gdk_event_expose()->area);
}

Pointer<Gdk::Region>
Gdk::EventExpose::region() const
{
	return new Region(gdk_event_expose()->region);
}

int
Gdk::EventExpose::count() const
{
	return gdk_event_expose()->count;
}

/*  Gdk::EventVisibilty
 */

Gdk::VisibilityState
Gdk::EventVisibility::state() const
{
	return (VisibilityState)gdk_event_visibility()->state;
}

/*  Gdk::EventMotion
 */

unsigned int
Gdk::EventMotion::time() const
{
	return gdk_event_motion()->time;
}

double
Gdk::EventMotion::x() const
{
	return gdk_event_motion()->x;
}

double
Gdk::EventMotion::y() const
{
	return gdk_event_motion()->y;
}

double*
Gdk::EventMotion::axes() const
{
	return gdk_event_motion()->axes;
}

Gdk::ModifierTypeField
Gdk::EventMotion::state() const
{
	return gdk_event_motion()->state;
}

bool
Gdk::EventMotion::is_hint() const
{
	return gdk_event_motion()->is_hint != 0;
}

Gdk::Device*
Gdk::EventMotion::device() const
{
	return G::Object::wrap<Device>(gdk_event_motion()->device);
}

double
Gdk::EventMotion::x_root() const
{
	return gdk_event_motion()->x_root;
}

double
Gdk::EventMotion::y_root() const
{
	return gdk_event_motion()->y_root;
}

/*  Gdk::EventButton
 */

unsigned int
Gdk::EventButton::time() const
{
	return gdk_event_button()->time;
}

double
Gdk::EventButton::x() const
{
	return gdk_event_button()->x;
}

double
Gdk::EventButton::y() const
{
	return gdk_event_button()->y;
}

double*
Gdk::EventButton::axes() const
{
	return gdk_event_button()->axes;
}

Gdk::ModifierTypeField
Gdk::EventButton::state() const
{
	return gdk_event_button()->state;
}

unsigned int
Gdk::EventButton::button() const
{
	return gdk_event_button()->button;
}

Gdk::Device*
Gdk::EventButton::device() const
{
	return G::Object::wrap<Device>(gdk_event_button()->device);
}

double
Gdk::EventButton::x_root() const
{
	return gdk_event_button()->x_root;
}

double
Gdk::EventButton::y_root() const
{
	return gdk_event_button()->y_root;
}

/*  Gdk::EventScroll
 */

unsigned int
Gdk::EventScroll::time() const
{
	return gdk_event_scroll()->time;
}

double
Gdk::EventScroll::x() const
{
	return gdk_event_scroll()->x;
}

double
Gdk::EventScroll::y() const
{
	return gdk_event_scroll()->y;
}

Gdk::ModifierTypeField
Gdk::EventScroll::state() const
{
	return gdk_event_scroll()->state;
}

Gdk::ScrollDirection
Gdk::EventScroll::direction() const
{
	return (ScrollDirection)gdk_event_scroll()->direction;
}

Gdk::Device*
Gdk::EventScroll::device() const
{
	return G::Object::wrap<Device>(gdk_event_scroll()->device);
}

double
Gdk::EventScroll::x_root() const
{
	return gdk_event_scroll()->x_root;
}

double
Gdk::EventScroll::y_root() const
{
	return gdk_event_scroll()->y_root;
}

/*  Gdk::EventKey
 */

unsigned int
Gdk::EventKey::time() const
{
	return gdk_event_key()->time;
}

Gdk::ModifierTypeField
Gdk::EventKey::state() const
{
	return gdk_event_key()->state;
}

Gdk::Keyval
Gdk::EventKey::keyval() const
{
	return gdk_event_key()->keyval;
}

unsigned short
Gdk::EventKey::hardware_keycode() const
{
	return gdk_event_key()->hardware_keycode;
}

unsigned char
Gdk::EventKey::group() const
{
	return gdk_event_key()->group;
}

/*  Gdk::EventCrossing
 */

Gdk::Window*
Gdk::EventCrossing::subwindow() const
{
	return G::Object::wrap<Window>(gdk_event_crossing()->subwindow);
}

unsigned int
Gdk::EventCrossing::time() const
{
	return gdk_event_crossing()->time;
}

double
Gdk::EventCrossing::x() const
{
	return gdk_event_crossing()->x;
}

double
Gdk::EventCrossing::y() const
{
	return gdk_event_crossing()->y;
}

double
Gdk::EventCrossing::x_root() const
{
	return gdk_event_crossing()->x_root;
}

double
Gdk::EventCrossing::y_root() const
{
	return gdk_event_crossing()->y_root;
}

Gdk::CrossingMode
Gdk::EventCrossing::mode() const
{
	return (CrossingMode)gdk_event_crossing()->mode;
}

Gdk::NotifyType
Gdk::EventCrossing::detail() const
{
	return (NotifyType)gdk_event_crossing()->detail;
}

bool
Gdk::EventCrossing::focus() const
{
	return gdk_event_crossing()->focus != 0;
}

Gdk::ModifierTypeField
Gdk::EventCrossing::state() const
{
	return gdk_event_crossing()->state;
}

/*  Gdk::EventFocus
 */

bool
Gdk::EventFocus::in() const
{
	return gdk_event_focus()->in != 0;
}

bool
Gdk::EventFocus::out() const
{
	return gdk_event_focus()->in == 0;
}

/*  Gdk::EventConfigure
 */

int
Gdk::EventConfigure::x() const
{
	return gdk_event_configure()->x;
}

int
Gdk::EventConfigure::y() const
{
	return gdk_event_configure()->y;
}

int
Gdk::EventConfigure::width() const
{
	return gdk_event_configure()->width;
}

int
Gdk::EventConfigure::height() const
{
	return gdk_event_configure()->height;
}

/*  Gdk::EventProperty
 */

Gdk::Atom
Gdk::EventProperty::atom() const
{
	return gdk_event_property()->atom;
}

unsigned int
Gdk::EventProperty::time() const
{
	return gdk_event_property()->time;
}

Gdk::PropertyState
Gdk::EventProperty::state() const
{
	return (PropertyState)gdk_event_property()->state;
}

/*  Gdk::EventSelection
 */

Gdk::Atom
Gdk::EventSelection::selection() const
{
	return gdk_event_selection()->selection;
}

Gdk::Atom
Gdk::EventSelection::target() const
{
	return gdk_event_selection()->target;
}

Gdk::Atom
Gdk::EventSelection::property() const
{
	return gdk_event_selection()->property;
}

unsigned int
Gdk::EventSelection::time() const
{
	return gdk_event_selection()->time;
}

GdkNativeWindow
Gdk::EventSelection::requestor() const
{
	return gdk_event_selection()->requestor;
}

/*  Gdk::EventProximity
 */

unsigned int
Gdk::EventProximity::time() const
{
	return gdk_event_proximity()->time;
}

Gdk::Device*
Gdk::EventProximity::device() const
{
	return G::Object::wrap<Device>(gdk_event_proximity()->device);
}

/*  Gdk::EventClient
 */

Gdk::Atom
Gdk::EventClient::message_type() const
{
	return gdk_event_client()->message_type;
}

unsigned short
Gdk::EventClient::data_format() const
{
	return gdk_event_client()->data_format;
}

const char*
Gdk::EventClient::char_data() const
{
	return gdk_event_client()->data.b;
}

const short*
Gdk::EventClient::short_data() const
{
	return gdk_event_client()->data.s;
}

const long*
Gdk::EventClient::long_data() const
{
	return gdk_event_client()->data.l;
}

/*  Gdk::EventSetting
 */

Gdk::SettingAction
Gdk::EventSetting::action() const
{
	return (SettingAction)gdk_event_setting()->action;
}

String
Gdk::EventSetting::name() const
{
	return gdk_event_setting()->name;
}

/*  Gdk::EventWindowState
 */

Gdk::WindowStateField
Gdk::EventWindowState::changed_mask() const
{
	return (WindowStateField)gdk_event_window_state()->changed_mask;
}

Gdk::WindowStateField
Gdk::EventWindowState::new_window_state() const
{
	return (WindowStateField)gdk_event_window_state()->new_window_state;
}

/*  Gdk::EventDND
 */

Gdk::DragContext*
Gdk::EventDND::context() const
{
	return G::Object::wrap<DragContext>(gdk_event_dnd()->context);
}

unsigned int 
Gdk::EventDND::time() const
{
	return gdk_event_dnd()->time;
}

short 
Gdk::EventDND::x_root() const
{
	return gdk_event_dnd()->x_root;
}

short 
Gdk::EventDND::y_root() const
{
	return gdk_event_dnd()->y_root;
}

