/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  visual.cc - GdkVisual C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "visual.h"
#include "screen.h"

using namespace Inti;

/*  Gdk::Visual
 */

Gdk::Visual::Visual(GdkVisual *visual, bool reference)
: G::Object((GObject*)visual, reference)
{
}
	
Gdk::Visual::~Visual()
{
}

const Gdk::Visual* 
Gdk::Visual::get_best()
{
	return G::Object::wrap<Visual>(gdk_visual_get_best());
}

const Gdk::Visual* 
Gdk::Visual::get_best(int depth)
{
	return G::Object::wrap<Visual>(gdk_visual_get_best_with_depth(depth));
}

const Gdk::Visual* 
Gdk::Visual::get_best(VisualType visual_type)
{
	return G::Object::wrap<Visual>(gdk_visual_get_best_with_type((GdkVisualType)visual_type));
}

const Gdk::Visual* 
Gdk::Visual::get_best(int depth, VisualType visual_type)
{
	return G::Object::wrap<Visual>(gdk_visual_get_best_with_both(depth, (GdkVisualType)visual_type));
}

const Gdk::Visual*
Gdk::Visual::get_system()
{
	return G::Object::wrap<Visual>(gdk_visual_get_system());
}

GdkVisualClass*
Gdk::Visual::gdk_visual_class() const
{ 
	return get_class<GdkVisualClass>(); 
}
	
Gdk::Visual::operator GdkVisual* () const 
{ 
	return this ? gdk_visual() : 0; 
}
	
Gdk::VisualType
Gdk::Visual::type() const
{
	return (VisualType)gdk_visual()->type;
}

int
Gdk::Visual::depth() const
{
	return gdk_visual()->depth;
}

Gdk::ByteOrder
Gdk::Visual::byte_order() const
{
	return (ByteOrder)gdk_visual()->byte_order;
}

int 
Gdk::Visual::colormap_size() const
{
	return gdk_visual()->colormap_size;
}

int 
Gdk::Visual::bits_per_rgb() const
{
	return gdk_visual()->bits_per_rgb;
}

unsigned int
Gdk::Visual::red_mask() const
{
	return gdk_visual()->red_mask;
}

int
Gdk::Visual::red_shift() const
{
	return gdk_visual()->red_shift;
}

int
Gdk::Visual::red_prec() const
{
	return gdk_visual()->red_prec;
}

unsigned int
Gdk::Visual::green_mask() const
{
	return gdk_visual()->green_mask;
}

int
Gdk::Visual::green_shift() const
{
	return gdk_visual()->green_shift;
}

int
Gdk::Visual::green_prec() const
{
	return gdk_visual()->green_prec;
}

unsigned int 
Gdk::Visual::blue_mask() const
{
	return gdk_visual()->blue_mask;
}

int
Gdk::Visual::blue_shift() const
{
	return gdk_visual()->blue_shift;
}

int 
Gdk::Visual::blue_prec() const
{
	return gdk_visual()->blue_prec;
}

int
Gdk::Visual::get_best_depth() const
{
	return gdk_visual_get_best_depth();
}

Gdk::VisualType
Gdk::Visual::get_best_type() const
{
	return (VisualType)gdk_visual_get_best_type();
}

std::vector<int>
Gdk::Visual::query_depths()
{
	int *tmp_depths = 0;
	int count = 0;
	gdk_query_depths(&tmp_depths, &count);

	std::vector<int> depths;
	int i = 0;
	while (i < count)
	{
		depths.push_back(tmp_depths[i]);
		++i;
	}
	return depths;
}

bool
Gdk::Visual::query_visual_types(std::vector<VisualType>& visual_types)
{
	g_return_val_if_fail(visual_types.empty(), false);
	GdkVisualType *types = 0;
	int count = 0;
	gdk_query_visual_types(&types, &count);

	int i = 0;
	while (i < count)
	{
		visual_types.push_back((VisualType)types[i]);
		++i;
	}
	return !visual_types.empty();
}

bool
Gdk::Visual::list_visuals(std::vector<const Visual*>& visuals)
{
	Screen *screen = Screen::get_default();
	return screen->list_visuals(visuals);
}

