/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  quark.cc - GQuark C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "quark.h"

using namespace Inti;

G::Quark::Quark(const char *str)
: Base(g_quark_from_string(str))
{
}

G::Quark::Quark(const String& str)
: Base(g_quark_from_string(str.c_str()))
{
}

G::Quark::Quark(GQuark quark)
: Base(quark)
{
}
	
G::Quark::Quark(const Quark& src) 
: Base(src.value_)
{
}
	
G::Quark& 
G::Quark::operator=(const Quark& src) 
{
	value_ = src.value_;
	return *this;
}

G::Quark::operator String() const
{
	return g_quark_to_string(value_);
}
	
G::Quark 
G::Quark::try_string(const char *str) 
{ 
	return Quark(g_quark_try_string(str));
}

