/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  buttonbox.cc - GtkButtonBox, GtkHButtonBox and GtkVButtonBox C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "buttonbox.h"
#include "private/buttonbox_p.h"

using namespace Inti;

/*  Gtk::ButtonBox
 */

Gtk::ButtonBox::ButtonBox(GtkButtonBox *button_box, bool reference)
: Box((GtkBox*)button_box, reference)
{
}

Gtk::ButtonBox::ButtonBox()
: Box((GtkBox*)ButtonBoxClass::create())
{
}

Gtk::ButtonBox::~ButtonBox()
{
}

GtkButtonBoxClass*
Gtk::ButtonBox::gtk_button_box_class() const 
{ 
	return get_class<GtkButtonBoxClass>(); 
}
	
Gtk::ButtonBox::operator GtkButtonBox* () const 
{ 
	return this ? gtk_button_box() : 0; 
}
	
Gtk::ButtonBoxStyle
Gtk::ButtonBox::get_layout() const
{
	return (ButtonBoxStyle)gtk_button_box_get_layout(gtk_button_box());
}

void
Gtk::ButtonBox::set_layout(ButtonBoxStyle layout_style)
{
	gtk_button_box_set_layout(gtk_button_box(), (GtkButtonBoxStyle)layout_style);
}

void 
Gtk::ButtonBox::set_child_secondary(Widget& child, bool is_secondary)
{
	gtk_button_box_set_child_secondary(gtk_button_box(), child.gtk_widget(), is_secondary);
}

/*  Gtk::ButtonBoxClass
 */

void
Gtk::ButtonBoxClass::init(GtkButtonBoxClass *g_class)
{
	BoxClass::init((GtkBoxClass*)g_class);
}

GType
Gtk::ButtonBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_BUTTON_BOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ButtonBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::ButtonBox properties
 */

const Gtk::ButtonBox::LayoutStylePropertyType Gtk::ButtonBox::layout_style_property("layout_style");

const Gtk::ButtonBox::SecondaryPropertyType Gtk::ButtonBox::secondary_property("secondary");

/*  Gtk::HButtonBox
 */

Gtk::HButtonBox::HButtonBox(GtkHButtonBox *hbutton_box, bool reference)
: ButtonBox((GtkButtonBox*)hbutton_box, reference)
{
}

Gtk::HButtonBox::HButtonBox(ButtonBoxStyle layout, int spacing)
: ButtonBox((GtkButtonBox*)HButtonBoxClass::create())
{
	set_layout(layout);
	set_spacing(spacing);
}

Gtk::HButtonBox::~HButtonBox()
{
}

GtkHButtonBoxClass* 
Gtk::HButtonBox::gtk_hbutton_box_class() const 
{ 
	return get_class<GtkHButtonBoxClass>(); 
}
	
Gtk::HButtonBox::operator GtkHButtonBox* () const 
{ 
	return this ? gtk_hbutton_box() : 0; 
}
	
/*  Gtk::HButtonBoxClass
 */

void
Gtk::HButtonBoxClass::init(GtkHButtonBoxClass *g_class)
{
	ButtonBoxClass::init((GtkButtonBoxClass*)g_class);
}

GType
Gtk::HButtonBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HBUTTON_BOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::HButtonBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::VButtonBox
 */

Gtk::VButtonBox::VButtonBox(GtkVButtonBox *vbutton_box, bool reference)
: ButtonBox((GtkButtonBox*)vbutton_box, reference)
{
}

Gtk::VButtonBox::VButtonBox(ButtonBoxStyle layout, int spacing)
: ButtonBox((GtkButtonBox*)VButtonBoxClass::create())
{
	set_layout(layout);
	set_spacing(spacing);
}

Gtk::VButtonBox::~VButtonBox()
{
}

GtkVButtonBoxClass* 
Gtk::VButtonBox::gtk_vbutton_box_class() const 
{ 
	return get_class<GtkVButtonBoxClass>();
}
	
Gtk::VButtonBox::operator GtkVButtonBox* () const 
{ 
	return this ? gtk_vbutton_box() : 0; 
}
	
/*  Gtk::VButtonBoxClass
 */

void
Gtk::VButtonBoxClass::init(GtkVButtonBoxClass *g_class)
{
	ButtonBoxClass::init((GtkButtonBoxClass*)g_class);
}

GType
Gtk::VButtonBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VBUTTON_BOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::VButtonBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

