 /*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/gtk/checkbutton.h
//! @brief A GtkCheckButton C++ wrapper interface.

#ifndef INTI_GTK_CHECK_BUTTON_H
#define INTI_GTK_CHECK_BUTTON_H

#ifndef INTI_GTK_TOGGLE_BUTTON_H
#include <inti/gtk/togglebutton.h>
#endif

#ifndef __GTK_CHECK_BUTTON_H__
#include <gtk/gtkcheckbutton.h>
#endif

namespace Inti {

namespace Gtk {

class CheckButtonClass;

//! @class CheckButton checkbutton.h inti/gtk/checkbutton.h
//! @brief A GtkCheckButton C++ wrapper class.
//!
//! A CheckButton places a discrete ToggleButton next to a widget, (usually a Label). See 
//! the section on ToggleButton widgets for more information about toggle/check buttons.
//! The important signal "toggled" is also inherited from ToggleButton.

class CheckButton : public ToggleButton
{
	friend class G::Object;
	friend class CheckButtonClass;

	CheckButton(const CheckButton&);
	CheckButton& operator=(const CheckButton&);

protected:
//! @name Constructors
//! @{

	explicit CheckButton(GtkCheckButton *check_button, bool reference = false);
	//!< Construct a new CheckButton from an existing GtkCheckButton.
	//!< @param check_button A pointer to a GtkCheckButton.
	//!< @param reference Set false if the initial reference count is floating, set true if it's not.
	//!<
	//!< <BR>The <EM>check_button</EM> can be a newly created GtkCheckButton or an existing
	//!< GtkCheckButton. (see G::Object::Object).

//! @}
//  Override this do_ method when you want to change the default behaviour of the GtkCheckButton.
	
	virtual void do_draw_indicator(GdkRectangle *area);

public:
//! @name Constructors
//! @{

	CheckButton();
	//!< Construct a new CheckButton.

	explicit CheckButton(const String& label, bool use_underline = false);
	//!< Construct a new CheckButton with a Label to its right.
	//!< @param label The text for the check button.
	//!< @param use_underline <EM>true</EM> if the label contains an underscore, indicating a mnemonic.
	//!<
	//!< <BR>If <EM>use_underline</EM> is true an underscore in label indicates that the next
	//!< character is the mnemonic accelerator for the checkbutton.

 	virtual ~CheckButton();
	//!< Destructor.

//! @}
//! @name Accessors
//! @{

	GtkCheckButton* gtk_check_button() const { return (GtkCheckButton*)instance; }
	//!< Get a pointer to the GtkCheckButton structure.

	GtkCheckButtonClass* gtk_check_button_class() const;
	//!< Get a pointer to the GtkCheckButtonClass structure.

	operator GtkCheckButton* () const;
	//!< Conversion operator; safely converts a CheckButton to a GtkCheckButton pointer.

//! @}
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_CHECK_BUTTON_H

