/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  handlebox.cc - GtkHandleBox C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "handlebox.h"
#include "private/handlebox_p.h"
#include "../gdk/window.h"

using namespace Inti;

/*  Gtk::HandleBox
 */

Gtk::HandleBox::HandleBox(GtkHandleBox *handle_box, bool reference)
: Bin((GtkBin*)handle_box, reference)
{
}

Gtk::HandleBox::HandleBox(ShadowType shadow_type)
: Bin((GtkBin*)HandleBoxClass::create())
{
	set_shadow_type(shadow_type);
}

Gtk::HandleBox::~HandleBox()
{
}

GtkHandleBoxClass*
Gtk::HandleBox::gtk_handle_box_class() const 
{ 
	return get_class<GtkHandleBoxClass>(); 
}
	
Gtk::HandleBox::operator GtkHandleBox* () const
{ 
	return this ? gtk_handle_box() : 0; 
}
	
bool 
Gtk::HandleBox::is_child_detached() const
{
	return gtk_handle_box()->child_detached;
}

Gdk::Window*
Gtk::HandleBox::get_bin_window() const
{
	return G::Object::wrap<Gdk::Window>(gtk_handle_box()->bin_window);
}

Gdk::Window*
Gtk::HandleBox::get_float_window() const
{
	return G::Object::wrap<Gdk::Window>(gtk_handle_box()->float_window);
}

Gtk::ShadowType
Gtk::HandleBox::get_shadow_type() const
{
	return (ShadowType)gtk_handle_box_get_shadow_type(gtk_handle_box());
}

Gtk::PositionType
Gtk::HandleBox::get_handle_position() const
{
	return (PositionType)gtk_handle_box_get_handle_position(gtk_handle_box());
}

Gtk::PositionType
Gtk::HandleBox::get_snap_edge() const
{
	return (PositionType)gtk_handle_box_get_snap_edge(gtk_handle_box());
}
  
void 
Gtk::HandleBox::set_shadow_type(ShadowType type)
{
	gtk_handle_box_set_shadow_type(gtk_handle_box(), (GtkShadowType)type);
}

void 
Gtk::HandleBox::set_handle_position(PositionType position)
{
	gtk_handle_box_set_handle_position(gtk_handle_box(), (GtkPositionType)position);
}

void
Gtk::HandleBox::set_snap_edge(PositionType edge)
{
	gtk_handle_box_set_snap_edge(gtk_handle_box(), (GtkPositionType)edge);
}

void
Gtk::HandleBox::unset_snap_edge()
{
	gtk_handle_box_set_snap_edge(gtk_handle_box(), (GtkPositionType)-1);
}

/*  Gtk::HandleBoxClass
 */

void
Gtk::HandleBoxClass::init(GtkHandleBoxClass *g_class)
{
	BinClass::init((GtkBinClass*)g_class);
	g_class->child_attached = &child_attached_proxy;
	g_class->child_detached = &child_detached_proxy;
}

GType
Gtk::HandleBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HANDLE_BOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::HandleBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::HandleBoxClass::child_attached_proxy(GtkHandleBox *handle_box, GtkWidget *child)
{
	HandleBox *tmp_handle_box = G::Object::pointer<HandleBox>(handle_box);
	if (tmp_handle_box)
		tmp_handle_box->on_child_attached(*G::Object::wrap<Widget>(child));
	else
	{
		GtkHandleBoxClass *g_class = G::TypeInstance::class_peek_parent<GtkHandleBoxClass>(GTK_HANDLE_BOX_GET_CLASS(handle_box));
		if (g_class->child_attached)
			g_class->child_attached(handle_box, child);
	}
}

void
Gtk::HandleBoxClass::child_detached_proxy(GtkHandleBox *handle_box, GtkWidget *child)
{
	HandleBox *tmp_handle_box = G::Object::pointer<HandleBox>(handle_box);
	if (tmp_handle_box)
		tmp_handle_box->on_child_detached(*G::Object::wrap<Widget>(child));
	else
	{
		GtkHandleBoxClass *g_class = G::TypeInstance::class_peek_parent<GtkHandleBoxClass>(GTK_HANDLE_BOX_GET_CLASS(handle_box));
		if (g_class->child_detached)
			g_class->child_detached(handle_box, child);
	}
}

/*  Signal handlers
 */

void
Gtk::HandleBox::on_child_attached(Widget& child)
{
	GtkHandleBoxClass *g_class = class_peek_parent<GtkHandleBoxClass>(gtk_handle_box_class());
	if (g_class->child_attached)
		g_class->child_attached(gtk_handle_box(), child.gtk_widget());
}

void
Gtk::HandleBox::on_child_detached(Widget& child)
{
	GtkHandleBoxClass *g_class = class_peek_parent<GtkHandleBoxClass>(gtk_handle_box_class());
	if (g_class->child_detached)
		g_class->child_detached(gtk_handle_box(), child.gtk_widget());
}

/* Properties
 */

const Gtk::HandleBox::ShadowTypePropertyType Gtk::HandleBox::shadow_type_property("shadow_type");

const Gtk::HandleBox::HandlePositionPropertyType Gtk::HandleBox::handle_position_property("handle_position");

const Gtk::HandleBox::SnapEdgePropertyType Gtk::HandleBox::snap_edge_property("snap_edge");

const Gtk::HandleBox::SnapEdgeSetPropertyType Gtk::HandleBox::snap_edge_set_property("snap_edge_set");

/*  Signals
 */

const Gtk::HandleBox::ChildAttachedSignalType Gtk::HandleBox::child_attached_signal("child_attached");

const Gtk::HandleBox::ChildDetachedSignalType Gtk::HandleBox::child_detached_signal("child_detached");

