/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  texttag_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_TEXT_TAG_CLASS_H
#define INTI_GTK_TEXT_TAG_CLASS_H

#include <inti/glib/private/object_p.h>

namespace Inti {

namespace Gtk {

/*  Gtk::TextTagClass
 */

class TextTagClass
{
public:
	static void init(GtkTextTagClass *g_class);

	static GType get_type();

	static void* create();

	static gboolean event_proxy(GtkTextTag *tag, GObject *event_object, GdkEvent *event, const GtkTextIter *iter);
};

/*  Gtk::TextTagTableClass
 */

class TextTagTableClass
{
public:
	static void init(GtkTextTagTableClass *g_class);

	static GType get_type();

	static void* create();

	static void tag_changed_proxy(GtkTextTagTable *table, GtkTextTag *tag, gboolean size_changed);

	static void tag_added_proxy(GtkTextTagTable *table, GtkTextTag *tag);

	static void tag_removed_proxy(GtkTextTagTable *table, GtkTextTag *tag);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_TEXT_TAG_CLASS_H

