/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  textview_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_TEXT_VIEW_CLASS_H
#define INTI_GTK_TEXT_VIEW_CLASS_H

#include <inti/gtk/private/container_p.h>

namespace Inti {

namespace Gtk {

class TextViewClass
{
public:
	static void init(GtkTextViewClass *g_class);

	static GType get_type();

	static void* create();

	static void set_scroll_adjustments_proxy(GtkTextView *text_view, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment);

	static void populate_popup_proxy(GtkTextView *text_view, GtkMenu *menu);

	static void set_anchor_proxy(GtkTextView *text_view);

	static void insert_at_cursor_proxy(GtkTextView *text_view, const gchar *str);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_TEXT_VIEW_CLASS_H

