/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  treemodel_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_TREE_MODEL_IFACE_H
#define INTI_GTK_TREE_MODEL_IFACE_H

namespace Inti {

namespace Gtk {

class TreeModelIface
{
public:
	static void init(GtkTreeModelIface *g_iface);

// Methods
	static GtkTreeModelFlags get_flags_proxy(GtkTreeModel *tree_model);

	static gint get_n_columns_proxy(GtkTreeModel *tree_model);

	static GType get_column_type_proxy(GtkTreeModel *tree_model, gint index);

	static gboolean get_iter_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter, GtkTreePath *path);

	static GtkTreePath* get_path_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter);

	static void get_value_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter, gint column, GValue *value);

	static gboolean iter_next_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter);

	static gboolean iter_children_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter, GtkTreeIter *parent);

	static gboolean iter_has_child_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter);

	static gint iter_n_children_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter);

	static gboolean iter_nth_child_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter, GtkTreeIter *parent, gint n);

	static gboolean iter_parent_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter, GtkTreeIter *child);

	static void ref_node_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter);

	static void unref_node_proxy(GtkTreeModel *tree_model, GtkTreeIter *iter);

// Signals
	static void row_changed_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter);

	static void row_inserted_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter);

	static void row_has_child_toggled_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter);

	static void row_deleted_proxy(GtkTreeModel *tree_model, GtkTreePath *path);

	static void rows_reordered_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter, gint *new_order);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_TREE_MODEL_IFACE_H

