/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  scrollbar.cc - GtkScrollbar, GtkHScrollbar and GtkVScrollbar C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "scrollbar.h"
#include "private/scrollbar_p.h"

using namespace Inti;

/*  Gtk::Scrollbar
 */

Gtk::Scrollbar::Scrollbar(GtkScrollbar *scrollbar, bool reference) 
: Range((GtkRange*)scrollbar, reference)
{
}

Gtk::Scrollbar::~Scrollbar()
{
}

GtkScrollbarClass* 
Gtk::Scrollbar::gtk_scrollbar_class() const 
{ 
	return get_class<GtkScrollbarClass>(); 
}
	
Gtk::Scrollbar::operator GtkScrollbar* () const 
{ 
	return this ? gtk_scrollbar() : 0; 
}
	
/*  Gtk::ScrollbarClass
 */

void
Gtk::ScrollbarClass::init(GtkScrollbarClass *g_class)
{
	RangeClass::init((GtkRangeClass*)g_class);
}

GType
Gtk::ScrollbarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SCROLLBAR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ScrollbarClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::HScrollbar
 */

Gtk::HScrollbar::HScrollbar(GtkHScrollbar *hscrollbar, bool reference) 
: Scrollbar((GtkScrollbar*)hscrollbar, reference)
{
}

Gtk::HScrollbar::HScrollbar()
: Scrollbar((GtkScrollbar*)HScrollbarClass::create())
{
}

Gtk::HScrollbar::HScrollbar(Adjustment& adjustment) 
: Scrollbar((GtkScrollbar*)HScrollbarClass::create())
{
	set("adjustment", adjustment.gtk_adjustment(), 0);
}

Gtk::HScrollbar::~HScrollbar() 
{
}

GtkHScrollbarClass* 
Gtk::HScrollbar::gtk_hscrollbar_class() const 
{ 
	return get_class<GtkHScrollbarClass>(); 
}
	
Gtk::HScrollbar::operator GtkHScrollbar* () const 
{ 
	return this ? gtk_hscrollbar() : 0; 
}
	
/*  Gtk::HScrollbarClass
 */

void
Gtk::HScrollbarClass::init(GtkHScrollbarClass *g_class)
{
	ScrollbarClass::init((GtkScrollbarClass*)g_class);
}

GType
Gtk::HScrollbarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HSCROLLBAR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::HScrollbarClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::VScrollbar
 */

Gtk::VScrollbar::VScrollbar(GtkVScrollbar *vscrollbar, bool reference) 
: Scrollbar((GtkScrollbar*)vscrollbar, reference)
{
}

Gtk::VScrollbar::VScrollbar() 
: Scrollbar((GtkScrollbar*)VScrollbarClass::create())
{
}

Gtk::VScrollbar::VScrollbar(Adjustment& adjustment) 
: Scrollbar((GtkScrollbar*)VScrollbarClass::create())
{
	set("adjustment", adjustment.gtk_adjustment(), 0);
}

Gtk::VScrollbar::~VScrollbar() 
{
}

GtkVScrollbarClass* 
Gtk::VScrollbar::gtk_vscrollbar_class() const 
{ 
	return get_class<GtkVScrollbarClass>(); 
}
	
Gtk::VScrollbar::operator GtkVScrollbar* () const 
{ 
	return this ? gtk_vscrollbar() : 0; 
}
	
/*  Gtk::VScrollbarClass
 */

void
Gtk::VScrollbarClass::init(GtkVScrollbarClass *g_class)
{
	ScrollbarClass::init((GtkScrollbarClass*)g_class);
}

GType
Gtk::VScrollbarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VSCROLLBAR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::VScrollbarClass::create()
{
	return g_object_new(get_type(), 0);
}

