/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  sizegroup.cc - GtkSizeGroup C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "sizegroup.h"
#include "private/sizegroup_p.h"
#include "widget.h"

using namespace Inti;

/*  Gtk::SizeGroup
 */

Gtk::SizeGroup::SizeGroup(GtkSizeGroup *size_group, bool reference) 
: G::Object((GObject*)size_group, reference)
{
}
	
Gtk::SizeGroup::SizeGroup(SizeGroupMode mode)
: G::Object((GObject*)SizeGroupClass::create())
{
	set_mode(mode);
}
	
Gtk::SizeGroup::~SizeGroup()
{
}
	
GtkSizeGroupClass* 
Gtk::SizeGroup::gtk_size_group_class() const 
{ 
	return get_class<GtkSizeGroupClass>(); 
}
	
Gtk::SizeGroup::operator GtkSizeGroup* () const
{ 
	return this ? gtk_size_group() : 0; 
}
	
Gtk::SizeGroupMode
Gtk::SizeGroup::get_mode() const
{
	return (SizeGroupMode)gtk_size_group_get_mode(gtk_size_group());
}

void
Gtk::SizeGroup::set_mode(SizeGroupMode mode)
{
	gtk_size_group_set_mode(gtk_size_group(), (GtkSizeGroupMode)mode);

}

void 
Gtk::SizeGroup::add_widget(Widget& widget)
{
	gtk_size_group_add_widget(gtk_size_group(), widget.gtk_widget());
}

void 
Gtk::SizeGroup::remove_widget(Widget& widget)
{
	gtk_size_group_remove_widget(gtk_size_group(), widget.gtk_widget());
}

/*  Gtk::SizeGroupClass
 */

void
Gtk::SizeGroupClass::init(GtkSizeGroupClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Gtk::SizeGroupClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SIZE_GROUP, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::SizeGroupClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::SizeGroup::ModePropertyType Gtk::SizeGroup::mode_property("mode");

