/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  togglebutton.cc - GtkToggleButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "togglebutton.h"
#include "private/togglebutton_p.h"

using namespace Inti;

/*  Gtk::ToggleButton
 */

Gtk::ToggleButton::ToggleButton(GtkToggleButton *toggle_button, bool reference)
: Button((GtkButton*)toggle_button, reference)
{
}

Gtk::ToggleButton::ToggleButton() 
: Button((GtkButton*)ToggleButtonClass::create())
{
}

Gtk::ToggleButton::ToggleButton(const String& label, bool use_underline)
: Button((GtkButton*)ToggleButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::ToggleButton::~ToggleButton()
{
}

GtkToggleButtonClass*
Gtk::ToggleButton::gtk_toggle_button_class() const 
{ 
	return get_class<GtkToggleButtonClass>(); 
}
	
Gtk::ToggleButton::operator GtkToggleButton* () const 
{
	return this ? gtk_toggle_button() : 0; 
}

bool
Gtk::ToggleButton::get_active() const
{
	return gtk_toggle_button_get_active(gtk_toggle_button());
}

bool
Gtk::ToggleButton::get_mode() const
{ 
	return gtk_toggle_button_get_mode(gtk_toggle_button()); 
}

bool
Gtk::ToggleButton::get_inconsistent() const
{
	return gtk_toggle_button_get_inconsistent(gtk_toggle_button());
}

void
Gtk::ToggleButton::set_mode(bool draw_indicator)
{
	gtk_toggle_button_set_mode(gtk_toggle_button(), draw_indicator);
}

void
Gtk::ToggleButton::set_active(bool is_active)
{
	gtk_toggle_button_set_active(gtk_toggle_button(), is_active);
}

void
Gtk::ToggleButton::set_inconsistent(bool setting)
{
	gtk_toggle_button_set_inconsistent(gtk_toggle_button(), setting);
}

void 
Gtk::ToggleButton::toggled()
{
	gtk_toggle_button_toggled(gtk_toggle_button());
}

/*  Gtk::ToggleButtonClass
 */

void
Gtk::ToggleButtonClass::init(GtkToggleButtonClass *g_class)
{
	ButtonClass::init((GtkButtonClass*)g_class);
	g_class->toggled = &toggled_proxy;
}

GType
Gtk::ToggleButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TOGGLE_BUTTON, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ToggleButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ToggleButtonClass::toggled_proxy(GtkToggleButton *toggle_button)
{
	ToggleButton *tmp_toggle_button = G::Object::pointer<ToggleButton>(toggle_button);
	if (tmp_toggle_button)
		tmp_toggle_button->on_toggled();
	else
	{
		GtkToggleButtonClass *tmp_class = GTK_TOGGLE_BUTTON_GET_CLASS(toggle_button);
		GtkToggleButtonClass *g_class = G::TypeInstance::class_peek_parent<GtkToggleButtonClass>(tmp_class);
		if (g_class->toggled)
			g_class->toggled(toggle_button);
	}
}

/*  Signal handlers
 */

void
Gtk::ToggleButton::on_toggled()
{
	GtkToggleButtonClass *g_class = class_peek_parent<GtkToggleButtonClass>(gtk_toggle_button_class());
	if (g_class->toggled)
		g_class->toggled(gtk_toggle_button());
}

/*  Properties
 */

const Gtk::ToggleButton::ActivePropertyType Gtk::ToggleButton::active_property("active");

const Gtk::ToggleButton::InconsistentPropertyType Gtk::ToggleButton::inconsistent_property("inconsistent");

const Gtk::ToggleButton::DrawIndicatorPropertyType Gtk::ToggleButton::draw_indicator_property("draw_indicator");

/*  Signals
 */

const Gtk::ToggleButton::ToggledSignalType Gtk::ToggleButton::toggled_signal("toggled");
