/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  coverage.cc - PangoCoverage C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "coverage.h"

using namespace Inti;

Pango::Coverage::Coverage()
: coverage_(pango_coverage_new())
{
}

Pango::Coverage::Coverage(PangoCoverage *coverage)
: coverage_(coverage)
{
	if (coverage_)
		pango_coverage_ref(coverage_);
}

Pango::Coverage::Coverage(const Coverage& src)
: coverage_(src.pango_coverage())
{
	if (coverage_)
		pango_coverage_ref(coverage_);
}

Pango::Coverage::~Coverage()
{
	if (coverage_)
	{
		pango_coverage_unref(coverage_);
		coverage_ = 0;
	}
}

Pango::Coverage&
Pango::Coverage::operator=(const Coverage& src)
{
	if (src.coverage_ == coverage_)
		return *this;

	if (coverage_)
		pango_coverage_unref(coverage_);

	coverage_ = src.coverage_;

	if (coverage_)
		pango_coverage_ref(coverage_);
	return *this;
}

Pointer<Pango::Coverage>
Pango::Coverage::from_bytes(unsigned char *bytes, int n_bytes)
{
	return new Coverage(pango_coverage_from_bytes(bytes, n_bytes));
}

Pango::Coverage::operator PangoCoverage* () const
{ 
	return this ? pango_coverage() : 0; 
}

Pango::CoverageLevel
Pango::Coverage::get(int index) const
{
	return (CoverageLevel)pango_coverage_get(pango_coverage(), index);
}

void
Pango::Coverage::set(int index, CoverageLevel level)
{
	pango_coverage_set(pango_coverage(), index, (PangoCoverageLevel)level);
}

void 
Pango::Coverage::max(const Coverage& other)
{
	pango_coverage_max(pango_coverage(), other.pango_coverage());
}

void 
Pango::Coverage::to_bytes(unsigned char **bytes, int *n_bytes)
{
	pango_coverage_to_bytes(pango_coverage(), bytes, n_bytes);
}

