@echo off
rem  ======================================================================
rem
rem  This is the main entry point for the build system.
rem
rem  Users should be sure to execute this file rather than 'ant' to ensure
rem  the correct version is being used with the correct configuration.
rem
rem  ======================================================================
rem
rem $Id: build.bat 21373 2008-08-05 19:10:51Z pgier $
rem
rem Authors:
rem     Jason Dillon <jason@planet57.com>
rem     Sacha Labourey <sacha.labourey@cogito-info.ch>
rem

@if not "%ECHO%" == ""  echo %ECHO%
@if "%OS%" == "Windows_NT"  setlocal

set DIRNAME=.\
if "%OS%" == "Windows_NT" set DIRNAME=%~dp0%
set PROGNAME=run.bat
if "%OS%" == "Windows_NT" set PROGNAME=%~nx0%

rem Read all command line arguments

set ARGS=
:loop
if [%1] == [] goto endloop
        set ARGS=%ARGS% %1
        shift
        goto loop
:endloop

rem ******************************************************
rem Ignore the ANT_HOME variable: we want to use *our*
rem ANT version and associated JARs.

set ANT_HOME=

rem ******************************************************
rem Ignore the users classpath, cause it might mess
rem things up

set CLASSPATH=

rem ******************************************************
rem Setup JAXP impl

set JAXP_DOM_FACTORY=org.apache.crimson.jaxp.DocumentBuilderFactoryImpl
set JAXP_SAX_FACTORY=org.apache.crimson.jaxp.SAXParserFactoryImpl
rem set JAXP_DOM_FACTORY=org.apache.xerces.jaxp.DocumentBuilderFactoryImpl
rem set JAXP_SAX_FACTORY=org.apache.xerces.jaxp.SAXParserFactoryImpl

set ANT_OPTS=-Djavax.xml.parsers.DocumentBuilderFactory=%JAXP_DOM_FACTORY% -Djavax.xml.parsers.SAXParserFactory=%JAXP_SAX_FACTORY%

rem ******************************************************
rem Misc JBoss setup

set ANT_OPTS=%ANT_OPTS% -Djava.protocol.handler.pkgs=org.jboss.net.protocol -Dbuild.script=build.bat

rem ******************************************************
rem Find ANT_HOME

set ANT_HOME=%DIRNAME%..\tools
set CLASSPATH=%ANT_HOME%

%ANT_HOME%\bin\ant %ANT_OPTS% %ARGS%

:END

if "%NOPAUSE%" == "" pause
