/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.*;

/**
 * An looping task.
 *
 * @version <pre>$Id: Loop.java 21939 2008-08-27 21:01:35Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class Loop
   extends ContainerTask
{
   /** The loop count. */
   protected int count = -1;

   /**
    * Set the loop count.
    *
    * @param count   The loop count.
    */
   public void setCount(final int count) {
      this.count = count;
   }

   /**
    * Validate the attributes for this task.
    *
    * @throws BuildException     Attributes are not valid.
    */
   protected void validate() throws BuildException {
      super.validate();

      if (count <= 0)
         throw new IllegalAttributeException("count", "must be > 0", this);
   }

   /**
    * Execute the configured target the configured number of times.
    */
   public void execute() throws BuildException {
      validate();

      log.verbose("looping '" + getOwningTarget() + "' for count: " + count);
      for (int i=0; i<count; i++) {
         log.debug("i: " + i);
         executeTasks();
      }
   }
}
