/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task.config;

import java.io.File;

import org.jboss.util.DirectoryBuilder;

/**
 * A special extention of {@link Library} for modules.  It sets
 * up the namespace differently.
 *
 * <p>Expects vendor dir to be under <tt><em>name</em>/output</tt>.
 *  
 * @version <tt>$Revision: 21628 $</tt>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class ModuleLibrary
   extends Library
{
   protected File getVendorDir()
   {
      DirectoryBuilder builder = new DirectoryBuilder(root);

      builder.cd(name).cd("output");
      File dir = builder.get();

      return dir;
   }
}
