/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task.module;

import java.util.Map;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;

import org.jboss.tools.buildmagic.task.util.TaskLogger;

/**
 * Abstract task for project and module info tasks.
 *
 * @version <pre>$Id: AbstractInfo.java 21939 2008-08-27 21:01:35Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public abstract class AbstractInfo
   extends Task
{
   /** Instance logger. */
   protected final TaskLogger log = new TaskLogger(this);

   protected String _if;
   protected String unless;

   public void setIf(final String property) {
      this._if = property;
   }

   public void setUnless(final String property) {
      this.unless = property;
   }

   protected boolean canContinue() {
      Map map = getProject().getProperties();
      if (_if != null && !map.containsKey(_if))
         return false;
      else if (unless != null && map.containsKey(unless))
         return false;

      return true;
   }
   
   protected String getProperty(String name) {
      return getProject().getProperty(name);
   }
}
