/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task.util;

import org.apache.tools.ant.*;

/**
 * A helper class to make logging from a task nicer.
 *
 * @version <pre>$Id: TaskLogger.java 21373 2008-08-05 19:10:51Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public final class TaskLogger
{
   protected Task task;

   public TaskLogger(final Task task) {
      this.task = task;
   }

   public void info(final String message) {
      task.log(message, Project.MSG_INFO);
   }

   public void error(final String message) {
      task.log(message, Project.MSG_ERR);
   }

   public void warning(final String message) {
      task.log(message, Project.MSG_WARN);
   }

   public void verbose(final String message) {
      task.log(message, Project.MSG_VERBOSE);
   }

   public void debug(final String message) {
      task.log(message, Project.MSG_DEBUG);
   }
}
