/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator.model;

import org.jfree.xml.generator.model.Comments;

public class TypeInfo {
    private String name;
    private Class type;
    private boolean nullable;
    private boolean constrained;
    private String description;
    private Comments comments;

    public TypeInfo(String name, Class type) {
        if (name == null) {
            throw new NullPointerException("Name");
        }
        this.name = name;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeInfo)) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)o;
        if (!this.name.equals(typeInfo.name)) {
            return false;
        }
        return this.type.equals(typeInfo.type);
    }

    public Comments getComments() {
        return this.comments;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 29 * result + this.type.hashCode();
        result = 29 * result + (this.nullable ? 1 : 0);
        result = 29 * result + (this.constrained ? 1 : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }
}

