package jdepend.framework;

import java.io.*;
import java.util.*;

/**
 * The <code>FilterTest</code> is a <code>TestCase</code> 
 * for the <code>PackageFilter</code> class.
 *
 * @author <b>Mike Clark</b> (mike@clarkware.com)
 * @author Clarkware Consulting, Inc.
 */
 
public class FilterTest extends JDependTestCase {

	public FilterTest(String name) {
		super(name);
	}

	protected void setUp() {
		super.setUp();
            
        System.setProperty("user.home", getTestDataDir());
	}
	
	protected void tearDown() {
	    super.tearDown();
	}

	public void testDefaultFilter() {
		PackageFilter filter = new PackageFilter();
		assertEquals(5, filter.getFilters().size());
        assertFiltersExist(filter);
	}
	
    public void testFilterFile() throws IOException  {
	
        String filterFile = getTestDataDir() + "jdepend.properties";
			
        PackageFilter filter = new PackageFilter(new File(filterFile));
        assertEquals(5, filter.getFilters().size());
        assertFiltersExist(filter);
    }
    
    public void testFilterCollection() throws IOException {
	
        Collection filters = new ArrayList();
        filters.add("java.*");
        filters.add("javax.*");
        filters.add("sun.*");
        filters.add("com.sun.*");
        filters.add("com.xyz.tests.*");
		
        PackageFilter filter = new PackageFilter(filters);
        assertEquals(5, filter.getFilters().size());
        assertFiltersExist(filter);	
    }
	
    public void testFilterCollectionSubset() {
        Collection filters = new ArrayList();
        filters.add("com.xyz");
        PackageFilter filter = new PackageFilter(filters);
        assertEquals(1, filter.getFilters().size());
    }
	
    private void assertFiltersExist(PackageFilter filter) {
        assertFalse(filter.accept("java.lang"));
        assertFalse(filter.accept("javax.ejb"));
        assertTrue(filter.accept("com.xyz.tests"));
        assertFalse(filter.accept("com.xyz.tests.a"));
        assertTrue(filter.accept("com.xyz.ejb"));
    }

	public static void main(String args[]) {
		junit.textui.TestRunner.run(FilterTest.class);
	}
}
